/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message.processing;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mule.execution.MessageProcessPhase;
import org.mule.execution.MessageProcessTemplate;

public class PhaseSupportTestHelper<T> {
    private final Class<T> supportedTemplateClass;
    private final T supportedTemplate;
    private final MessageProcessTemplate notSupportedTemplate;

    public PhaseSupportTestHelper(Class<T> supportedTemplate) {
        this.supportedTemplateClass = supportedTemplate;
        this.supportedTemplate = Mockito.mock(this.supportedTemplateClass);
        this.notSupportedTemplate = (MessageProcessTemplate)Mockito.mock(MessageProcessTemplate.class);
    }

    public void testSupportTemplates(MessageProcessPhase messageProcessPhase) {
        this.notSupportedTemplateTest(messageProcessPhase);
        this.supportedTemplateTest(messageProcessPhase);
    }

    public void notSupportedTemplateTest(MessageProcessPhase messageProcessPhase) {
        Assert.assertThat((Object)messageProcessPhase.supportsTemplate(this.notSupportedTemplate), (Matcher)Is.is((Object)false));
    }

    public void supportedTemplateTest(MessageProcessPhase messageProcessPhase) {
        Assert.assertThat((Object)messageProcessPhase.supportsTemplate((MessageProcessTemplate)this.supportedTemplate), (Matcher)Is.is((Object)true));
    }
}

