/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.expression.RequiredValueException;
import org.mule.expression.AbstractAttachmentsTestCase;
import org.mule.expression.MessageAttachmentsExpressionEvaluator;

public class MessageAttachmentsExpressionEvaluatorTestCase
extends AbstractAttachmentsTestCase {
    private MessageAttachmentsExpressionEvaluator evaluator = new MessageAttachmentsExpressionEvaluator();

    @Test
    public void requiredKeysWithExistingAttachmentsShouldReturnAttachments() throws Exception {
        Object result = this.evaluator.evaluate("foo, baz", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        this.assertAttachmentWithKeyHasValue("foo", "foovalue", map);
        this.assertAttachmentWithKeyHasValue("baz", "bazvalue", map);
    }

    @Test
    public void requiredKeysWithExistingAttachmentsViaExpressionManagerShouldReturnAttachments() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:foo, baz]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        this.assertAttachmentWithKeyHasValue("foo", "foovalue", map);
        this.assertAttachmentWithKeyHasValue("baz", "bazvalue", map);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredKeysWithMissingAttachmentsShouldFail() {
        this.evaluator.evaluate("nonexistent", this.message);
    }

    @Test(expected=RequiredValueException.class)
    public void requiredKeysWithMissingAttachmentsViaExpressionManagerShouldFail() {
        muleContext.getExpressionManager().evaluate("#[attachments:nonexistent[", this.message);
    }

    @Test
    public void optionalKeysWithExistingAttachmentsShouldReturnAttachments() throws Exception {
        Object result = this.evaluator.evaluate("foo?,bar?", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        this.assertAttachmentWithKeyHasValue("foo", "foovalue", map);
        this.assertAttachmentWithKeyHasValue("bar", "barvalue", map);
    }

    @Test
    public void optionalKeysWithExistingAttachmentsViaExpressionManagerShouldReturnAttachments() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:foo?, bar?]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        this.assertAttachmentWithKeyHasValue("foo", "foovalue", map);
        this.assertAttachmentWithKeyHasValue("bar", "barvalue", map);
    }

    @Test
    public void optionalKeysWithMissingAttachmentsShouldReturnEmptyMap() throws Exception {
        Object result = this.evaluator.evaluate("nonexistent?", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void optionalKeysWithMissingAttachmentsViaExpressionManagerShouldReturnEmptyMap() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:nonexistent?]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void matchAllWildcardShouldReturnAllAttachments() throws Exception {
        Object result = this.evaluator.evaluate("*", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)3L, (long)map.size());
        this.assertAttachmentWithKeyHasValue("foo", "foovalue", map);
        this.assertAttachmentWithKeyHasValue("bar", "barvalue", map);
        this.assertAttachmentWithKeyHasValue("baz", "bazvalue", map);
    }

    @Test
    public void matchAllWildcardViaExpressionManagerShouldReturnAllAttachments() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:*]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)3L, (long)map.size());
        this.assertAttachmentWithKeyHasValue("foo", "foovalue", map);
        this.assertAttachmentWithKeyHasValue("bar", "barvalue", map);
        this.assertAttachmentWithKeyHasValue("baz", "bazvalue", map);
    }

    @Test
    public void matchBeginningWildcardShouldReturnAttachments() throws Exception {
        Object result = this.evaluator.evaluate("ba*", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        this.assertAttachmentWithKeyHasValue("bar", "barvalue", map);
        this.assertAttachmentWithKeyHasValue("baz", "bazvalue", map);
    }

    @Test
    public void matchBeginningWildcardViaExpressionManagerShouldReturnAttachments() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:ba*]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)2L, (long)map.size());
        this.assertAttachmentWithKeyHasValue("bar", "barvalue", map);
        this.assertAttachmentWithKeyHasValue("baz", "bazvalue", map);
    }

    @Test
    public void wildcardWithNoMatchShouldReturnEmptyMap() {
        Object result = this.evaluator.evaluate("x*", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void wildcardWithNoMatchViaExpressionManagerShouldReturnEmptyMap() {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:x*]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void multipleWildcardsShouldReturnValues() throws Exception {
        Object result = this.evaluator.evaluate("ba*, f*", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)3L, (long)map.size());
        this.assertAttachmentWithKeyHasValue("foo", "foovalue", map);
        this.assertAttachmentWithKeyHasValue("bar", "barvalue", map);
        this.assertAttachmentWithKeyHasValue("baz", "bazvalue", map);
    }

    @Test
    public void multipleWildcardsViaExpressionManagerShouldReturnValues() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[attachments:ba*, f*]", this.message);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((long)3L, (long)map.size());
        this.assertAttachmentWithKeyHasValue("foo", "foovalue", map);
        this.assertAttachmentWithKeyHasValue("bar", "barvalue", map);
        this.assertAttachmentWithKeyHasValue("baz", "bazvalue", map);
    }

    private void assertAttachmentWithKeyHasValue(String key, String expectedValue, Map<?, ?> map) throws IOException {
        Object attachment = map.get(key);
        Assert.assertNotNull(attachment);
        this.assertAttachmentValueEquals(expectedValue, attachment);
    }
}

