/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.Pipeline;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.processor.MessageProcessor;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.execution.MessageProcessorExecutionInterceptor;
import org.mule.execution.MessageProcessorNotificationExecutionInterceptor;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class MessageProcessorNotificationExecutionInterceptorTestCase
extends AbstractMuleTestCase {
    @Mock
    private ServerNotificationManager mockNotificationManager;
    @Mock
    private MessageProcessorExecutionInterceptor mockNextInterceptor;
    @Mock
    private MessageProcessor mockMessageProcessor;
    @Mock
    private Pipeline mockPipeline;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent mockMuleEvent;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent mockResultMuleEvent;
    @Mock
    private MessagingException mockMessagingException;
    private MessageProcessorNotificationExecutionInterceptor messageProcessorNotificationExecutionInterceptor;

    @Before
    public void setUpTest() {
        this.messageProcessorNotificationExecutionInterceptor = new MessageProcessorNotificationExecutionInterceptor(this.mockNextInterceptor);
    }

    @Test
    public void testExecutionSuccessfully() throws MuleException {
        final ArrayList serverNotifications = new ArrayList();
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        Mockito.when((Object)this.mockPipeline.getProcessorPath(this.mockMessageProcessor)).thenReturn((Object)"hi");
        Mockito.when((Object)this.mockMuleEvent.getMuleContext().getNotificationManager()).thenReturn((Object)this.mockNotificationManager);
        Mockito.when((Object)this.mockMuleEvent.getFlowConstruct()).thenReturn((Object)this.mockPipeline);
        Mockito.when((Object)this.mockMuleEvent.isNotificationsEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNextInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        Mockito.when((Object)this.mockNotificationManager.isNotificationEnabled(MessageProcessorNotification.class)).thenReturn((Object)true);
        ((ServerNotificationManager)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                serverNotifications.add((ServerNotification)invocationOnMock.getArguments()[0]);
                return null;
            }
        }).when((Object)this.mockNotificationManager)).fireNotification((ServerNotification)Mockito.any(ServerNotification.class));
        MuleEvent result = this.messageProcessorNotificationExecutionInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.mockResultMuleEvent));
        Assert.assertThat((Object)serverNotifications.size(), (Matcher)Is.is((Object)2));
        MessageProcessorNotification beforeMessageProcessorNotification = (MessageProcessorNotification)serverNotifications.get(0);
        MessageProcessorNotification afterMessageProcessorNotification = (MessageProcessorNotification)serverNotifications.get(1);
        Assert.assertThat((Object)beforeMessageProcessorNotification.getAction(), (Matcher)Is.is((Object)1601));
        Assert.assertThat((Object)beforeMessageProcessorNotification.getProcessor(), (Matcher)Is.is((Object)this.mockMessageProcessor));
        Assert.assertThat((Object)((Object)beforeMessageProcessorNotification.getExceptionThrown()), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)afterMessageProcessorNotification.getAction(), (Matcher)Is.is((Object)1602));
        Assert.assertThat((Object)afterMessageProcessorNotification.getProcessor(), (Matcher)Is.is((Object)this.mockMessageProcessor));
        Assert.assertThat((Object)((Object)afterMessageProcessorNotification.getExceptionThrown()), (Matcher)IsNull.nullValue());
    }

    @Test
    public void ignoresSuccessfulNotificationIfDisabled() throws MuleException {
        final ArrayList serverNotifications = new ArrayList();
        Mockito.when((Object)this.mockMessageProcessor.process(this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        Mockito.when((Object)this.mockMuleEvent.getMuleContext().getNotificationManager()).thenReturn((Object)this.mockNotificationManager);
        Mockito.when((Object)this.mockNextInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent)).thenReturn((Object)this.mockResultMuleEvent);
        Mockito.when((Object)this.mockNotificationManager.isNotificationEnabled(MessageProcessorNotification.class)).thenReturn((Object)true);
        ((ServerNotificationManager)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                serverNotifications.add((ServerNotification)invocationOnMock.getArguments()[0]);
                return null;
            }
        }).when((Object)this.mockNotificationManager)).fireNotification((ServerNotification)Mockito.any(ServerNotification.class));
        MuleEvent result = this.messageProcessorNotificationExecutionInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)this.mockResultMuleEvent));
        Assert.assertThat((Object)serverNotifications.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testExecutionFailure() throws MuleException {
        final ArrayList serverNotifications = new ArrayList();
        Mockito.when((Object)this.mockNextInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent)).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockPipeline.getProcessorPath(this.mockMessageProcessor)).thenReturn((Object)"hi");
        Mockito.when((Object)this.mockMuleEvent.getFlowConstruct()).thenReturn((Object)this.mockPipeline);
        Mockito.when((Object)this.mockMuleEvent.getMuleContext().getNotificationManager()).thenReturn((Object)this.mockNotificationManager);
        Mockito.when((Object)this.mockMuleEvent.isNotificationsEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNotificationManager.isNotificationEnabled(MessageProcessorNotification.class)).thenReturn((Object)true);
        ((ServerNotificationManager)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                serverNotifications.add((ServerNotification)invocationOnMock.getArguments()[0]);
                return null;
            }
        }).when((Object)this.mockNotificationManager)).fireNotification((ServerNotification)Mockito.any(ServerNotification.class));
        try {
            this.messageProcessorNotificationExecutionInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException e) {
            // empty catch block
        }
        Assert.assertThat((Object)serverNotifications.size(), (Matcher)Is.is((Object)2));
        MessageProcessorNotification beforeMessageProcessorNotification = (MessageProcessorNotification)serverNotifications.get(0);
        MessageProcessorNotification afterMessageProcessorNotification = (MessageProcessorNotification)serverNotifications.get(1);
        Assert.assertThat((Object)beforeMessageProcessorNotification.getAction(), (Matcher)Is.is((Object)1601));
        Assert.assertThat((Object)beforeMessageProcessorNotification.getProcessor(), (Matcher)Is.is((Object)this.mockMessageProcessor));
        Assert.assertThat((Object)((Object)beforeMessageProcessorNotification.getExceptionThrown()), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)afterMessageProcessorNotification.getAction(), (Matcher)Is.is((Object)1602));
        Assert.assertThat((Object)afterMessageProcessorNotification.getProcessor(), (Matcher)Is.is((Object)this.mockMessageProcessor));
        Assert.assertThat((Object)((Object)afterMessageProcessorNotification.getExceptionThrown()), (Matcher)Is.is((Object)((Object)this.mockMessagingException)));
    }

    @Test
    public void ignoresFailureNotificationIfDisabled() throws MuleException {
        final ArrayList serverNotifications = new ArrayList();
        Mockito.when((Object)this.mockNextInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent)).thenThrow(new Throwable[]{this.mockMessagingException});
        Mockito.when((Object)this.mockMuleEvent.getMuleContext().getNotificationManager()).thenReturn((Object)this.mockNotificationManager);
        Mockito.when((Object)this.mockNotificationManager.isNotificationEnabled(MessageProcessorNotification.class)).thenReturn((Object)true);
        ((ServerNotificationManager)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                serverNotifications.add((ServerNotification)invocationOnMock.getArguments()[0]);
                return null;
            }
        }).when((Object)this.mockNotificationManager)).fireNotification((ServerNotification)Mockito.any(ServerNotification.class));
        try {
            this.messageProcessorNotificationExecutionInterceptor.execute(this.mockMessageProcessor, this.mockMuleEvent);
            Assert.fail((String)"Exception should be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        Assert.assertThat((Object)serverNotifications.size(), (Matcher)Is.is((Object)0));
    }
}

