/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.el.context.AbstractELTestCase;
import org.mule.el.context.MessageContext;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;

public class MessageContextTestCase
extends AbstractELTestCase {
    public MessageContextTestCase(AbstractELTestCase.Variant variant, String mvelOptimizer) {
        super(variant, mvelOptimizer);
    }

    @Test
    public void message() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"foo", muleContext);
        Assert.assertTrue((boolean)(this.evaluate("message", (MuleMessage)message) instanceof MessageContext));
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.payload", (MuleMessage)message));
    }

    @Test
    public void assignToMessage() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertImmutableVariable("message='foo'", (MuleMessage)message);
    }

    @Test
    public void messageId() throws Exception {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getUniqueId()).thenReturn((Object)"1");
        Assert.assertEquals((Object)"1", (Object)this.evaluate("message.id", message));
        this.assertFinalProperty("message.id=2", message);
    }

    @Test
    public void rootId() throws Exception {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getMessageRootId()).thenReturn((Object)"2");
        Assert.assertEquals((Object)"2", (Object)this.evaluate("message.rootId", message));
        this.assertFinalProperty("message.rootId=2", message);
    }

    @Test
    public void correlationId() throws Exception {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getCorrelationId()).thenReturn((Object)"3");
        Assert.assertEquals((Object)"3", (Object)this.evaluate("message.correlationId", message));
        this.assertFinalProperty("message.correlationId=2", message);
    }

    @Test
    public void correlationSequence() throws Exception {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getCorrelationSequence()).thenReturn((Object)4);
        Assert.assertEquals((Object)4, (Object)this.evaluate("message.correlationSequence", message));
        this.assertFinalProperty("message.correlationSequence=2", message);
    }

    @Test
    public void correlationGroupSize() throws Exception {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getCorrelationGroupSize()).thenReturn((Object)4);
        Assert.assertEquals((Object)4, (Object)this.evaluate("message.correlationGroupSize", message));
        this.assertFinalProperty("message.correlationGroupSize=2", message);
    }

    @Test
    public void replyTo() throws Exception {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getReplyTo()).thenReturn((Object)"replyQueue");
        Assert.assertEquals((Object)"replyQueue", (Object)this.evaluate("message.replyTo", message));
        this.assertFinalProperty("message.correlationGroupSize=2", message);
    }

    @Test
    public void assignValueToReplyTo() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.evaluate("message.replyTo='my://uri'", (MuleMessage)message);
        Assert.assertEquals((Object)"my://uri", (Object)message.getReplyTo());
    }

    @Test
    public void dataType() throws Exception {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getDataType()).thenReturn((Object)DataTypeFactory.STRING);
        Assert.assertEquals((Object)DataTypeFactory.STRING, (Object)this.evaluate("message.dataType", message));
        this.assertFinalProperty("message.mimType=2", message);
    }

    @Test
    public void payload() throws Exception {
        MuleMessage mockMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Object payload = new Object();
        Mockito.when((Object)mockMessage.getPayload()).thenReturn(payload);
        Assert.assertSame((Object)payload, (Object)this.evaluate("message.payload", mockMessage));
    }

    @Test
    public void assignPayload() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.evaluate("message.payload = 'foo'", (MuleMessage)message);
        Assert.assertEquals((Object)"foo", (Object)message.getPayload());
    }

    @Test
    public void payloadAsType() throws Exception {
        MuleMessage mockMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Banana b = new Banana();
        Mockito.when((Object)mockMessage.getPayload((Class)Mockito.any(Class.class))).thenReturn((Object)b);
        Assert.assertSame((Object)b, (Object)this.evaluate("message.payloadAs(org.mule.tck.testmodels.fruit.Banana)", mockMessage));
    }

    @Test
    public void payloadAsDataType() throws Exception {
        MuleMessage mockMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Banana b = new Banana();
        Mockito.when((Object)mockMessage.getPayload((DataType)Mockito.any(DataType.class))).thenReturn((Object)b);
        Assert.assertSame((Object)b, (Object)this.evaluate("message.payloadAs(org.mule.transformer.types.DataTypeFactory.STRING)", mockMessage));
    }

    @Test
    public void nullPayloadTest() throws Exception {
        MuleMessage mockMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)mockMessage.getPayload()).thenReturn((Object)NullPayload.getInstance());
        Assert.assertEquals((Object)true, (Object)this.evaluate("message.payload == null", mockMessage));
        Assert.assertEquals((Object)false, (Object)this.evaluate("message.payload is NullPayload", mockMessage));
        Assert.assertEquals((Object)true, (Object)this.evaluate("message.payload == empty", mockMessage));
    }
}

