/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.el.ExpressionLanguage;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageExtension;
import org.mule.api.el.ExpressionLanguageFunction;
import org.mule.api.el.VariableAssignmentCallback;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.el.context.AbstractELTestCase;
import org.mule.el.context.AppContext;
import org.mule.el.mvel.MVELExpressionLanguage;

public class ExpressionLanguageExtensionTestCase
extends AbstractELTestCase {
    private String a = "hi";
    private String b = "hi";

    public ExpressionLanguageExtensionTestCase(AbstractELTestCase.Variant variant, String mvelOptimizer) {
        super(variant, mvelOptimizer);
    }

    @Override
    protected ConfigurationBuilder getBuilder() throws Exception {
        return new SimpleConfigurationBuilder(Collections.singletonMap("key1", new TestExtension()));
    }

    @Override
    protected ExpressionLanguage getExpressionLanguage() throws RegistrationException {
        MVELExpressionLanguage mvel = new MVELExpressionLanguage(muleContext);
        return mvel;
    }

    @Test
    public void importClass() throws RegistrationException, InitialisationException {
        Assert.assertEquals(Calendar.class, (Object)this.expressionLanguage.evaluate("Calendar"));
    }

    @Test
    public void importClassWithName() throws RegistrationException, InitialisationException {
        Assert.assertEquals(Calendar.class, (Object)this.expressionLanguage.evaluate("CAL"));
    }

    @Test
    public void importStaticMethod() throws RegistrationException, InitialisationException {
        Assert.assertEquals((Object)DateFormat.getInstance(), (Object)this.expressionLanguage.evaluate("dateFormat()"));
    }

    @Test
    public void variable() throws RegistrationException, InitialisationException {
        Assert.assertEquals((Object)"hi", (Object)this.expressionLanguage.evaluate("a"));
    }

    @Test
    public void assignValueToVariable() throws RegistrationException, InitialisationException {
        this.expressionLanguage.evaluate("a='1'");
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void assignValueToFinalVariable() throws RegistrationException, InitialisationException {
        this.expressionLanguage.evaluate("final='1'");
    }

    @Test
    public void mutableVariable() throws RegistrationException, InitialisationException {
        Assert.assertEquals((Object)"hi", (Object)this.expressionLanguage.evaluate("b"));
    }

    @Test
    public void assignValueToMutableVariable() throws RegistrationException, InitialisationException {
        Assert.assertEquals((Object)"hi", (Object)this.expressionLanguage.evaluate("b='1'"));
        Assert.assertEquals((Object)"1", (Object)this.b);
    }

    @Test
    public void testShortcutVariable() throws RegistrationException, InitialisationException {
        MVELExpressionLanguage mvel = new MVELExpressionLanguage(muleContext);
        mvel.initialise();
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)mvel.evaluate("appShortcut.name"));
    }

    @Test
    public void testVariableAlias() throws RegistrationException, InitialisationException {
        MVELExpressionLanguage mvel = new MVELExpressionLanguage(muleContext);
        mvel.initialise();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"foo", muleContext);
        Assert.assertEquals((Object)"foo", (Object)mvel.evaluate("p", (MuleMessage)message));
    }

    @Test
    public void testAssignValueToVariableAlias() throws RegistrationException, InitialisationException {
        MVELExpressionLanguage mvel = new MVELExpressionLanguage(muleContext);
        mvel.initialise();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"foo", muleContext);
        mvel.evaluate("p='bar'", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)message.getPayload());
    }

    @Test
    public void testMuleMessageAvailableAsVariable() throws Exception {
        MVELExpressionLanguage mvel = new MVELExpressionLanguage(muleContext);
        mvel.initialise();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"foo", muleContext);
        mvel.evaluate("p=m.uniqueId", (MuleMessage)message);
        Assert.assertEquals((Object)message.getUniqueId(), (Object)message.getPayload());
    }

    @Test
    public void testFunction() throws RegistrationException, InitialisationException {
        MVELExpressionLanguage mvel = new MVELExpressionLanguage(muleContext);
        mvel.initialise();
        Assert.assertEquals((Object)("called param[0]=one,param[1]=two,app.name=" + muleContext.getConfiguration().getId()), (Object)mvel.evaluate("f('one','two')"));
    }

    @Test
    public void testMuleContextAvailableInFunction() throws RegistrationException, InitialisationException {
        MVELExpressionLanguage mvel = new MVELExpressionLanguage(muleContext);
        mvel.initialise();
        Assert.assertEquals((Object)muleContext, (Object)mvel.evaluate("muleContext()"));
    }

    @Test
    public void testMuleMessageAvailableInFunction() throws RegistrationException, InitialisationException {
        MVELExpressionLanguage mvel = new MVELExpressionLanguage(muleContext);
        mvel.initialise();
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Assert.assertEquals((Object)message, (Object)mvel.evaluate("muleMessage()", message));
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void testFunctionInvalidParams() throws RegistrationException, InitialisationException {
        MVELExpressionLanguage mvel = new MVELExpressionLanguage(muleContext);
        mvel.initialise();
        mvel.evaluate("f('one')");
    }

    class TestExtension
    implements ExpressionLanguageExtension {
        TestExtension() {
        }

        public void configureContext(ExpressionLanguageContext context) {
            context.importClass(Calendar.class);
            context.importClass("CAL", Calendar.class);
            try {
                context.importStaticMethod("dateFormat", DateFormat.class.getMethod("getInstance", new Class[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            context.addVariable("a", (Object)ExpressionLanguageExtensionTestCase.this.a);
            context.addVariable("b", (Object)ExpressionLanguageExtensionTestCase.this.b, (VariableAssignmentCallback)new VariableAssignmentCallback<String>(){

                public void assignValue(String name, String value, String newValue) {
                    ExpressionLanguageExtensionTestCase.this.b = newValue;
                }
            });
            context.addAlias("appShortcut", "app");
            context.addFinalVariable("final", (Object)"final");
            context.addAlias("p", "message.payload");
            try {
                context.addAlias("m", "_muleMessage");
            }
            catch (Exception exception) {
                // empty catch block
            }
            context.declareFunction("f", new ExpressionLanguageFunction(){

                public Object call(Object[] params, ExpressionLanguageContext context) {
                    return "called param[0]=" + params[0] + ",param[1]=" + params[1] + ",app.name=" + ((AppContext)context.getVariable("app")).getName();
                }
            });
            context.declareFunction("muleContext", new ExpressionLanguageFunction(){

                public Object call(Object[] params, ExpressionLanguageContext context) {
                    return context.getVariable("_muleContext");
                }
            });
            context.declareFunction("muleMessage", new ExpressionLanguageFunction(){

                public Object call(Object[] params, ExpressionLanguageContext context) {
                    return context.getVariable("_muleMessage");
                }
            });
        }
    }
}

