/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.DefaultMuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Callable;
import org.mule.api.object.ObjectFactory;
import org.mule.component.AbstractComponentTestCase;
import org.mule.component.SimpleCallableJavaComponent;
import org.mule.object.PrototypeObjectFactory;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;

public class SimpleCallableJavaComponentTestCase
extends AbstractComponentTestCase {
    @Test
    public void testComponentCreationWithObjectFactory() throws Exception {
        PrototypeObjectFactory objectFactory = new PrototypeObjectFactory(Apple.class);
        objectFactory.setObjectClass(Apple.class);
        objectFactory.initialise();
        SimpleCallableJavaComponent component = new SimpleCallableJavaComponent((ObjectFactory)objectFactory);
        Assert.assertNotNull((Object)component.getObjectFactory());
        Assert.assertEquals((Object)objectFactory, (Object)component.getObjectFactory());
        Assert.assertEquals(Apple.class, (Object)component.getObjectFactory().getObjectClass());
        Assert.assertEquals(Apple.class, (Object)component.getObjectType());
        objectFactory = new PrototypeObjectFactory(Orange.class);
        objectFactory.setObjectClass(Orange.class);
        objectFactory.initialise();
        try {
            component = new SimpleCallableJavaComponent((ObjectFactory)objectFactory);
        }
        catch (Exception e) {
            Assert.assertSame(DefaultMuleException.class, e.getClass());
        }
    }

    @Test
    public void testDirectComponentCreation() throws Exception {
        SimpleCallableJavaComponent component = new SimpleCallableJavaComponent(Apple.class);
        Assert.assertNotNull((Object)component.getObjectFactory());
        Assert.assertEquals(Apple.class, (Object)component.getObjectFactory().getObjectClass());
        Assert.assertEquals(Apple.class, (Object)component.getObjectType());
        try {
            component = new SimpleCallableJavaComponent(Orange.class);
        }
        catch (Exception e) {
            Assert.assertSame(DefaultMuleException.class, e.getClass());
        }
    }

    @Test
    public void testSimpleComponentCreation() throws Exception {
        SimpleCallableJavaComponent component = new SimpleCallableJavaComponent((Callable)new Apple());
        Assert.assertNotNull((Object)component.getObjectFactory());
        Assert.assertEquals(Apple.class, (Object)component.getObjectFactory().getObjectClass());
        Assert.assertEquals(Apple.class, (Object)component.getObjectType());
        try {
            component = new SimpleCallableJavaComponent((Callable)new Orange());
        }
        catch (Exception e) {
            Assert.assertSame(DefaultMuleException.class, e.getClass());
        }
    }

    @Test
    public void testLifecycle() throws Exception {
        SimpleCallableJavaComponent component = new SimpleCallableJavaComponent((Callable)new Apple());
        component.setFlowConstruct((FlowConstruct)SimpleCallableJavaComponentTestCase.getTestService());
        component.setMuleContext(muleContext);
        component.initialise();
        component.start();
        Assert.assertNull((Object)component.borrowComponentLifecycleAdaptor());
        Object obj = component.getObjectFactory().getInstance(muleContext);
        Assert.assertNotNull((Object)obj);
        component.stop();
        component.dispose();
    }
}

