/*
 * Decompiled with CFR 0.152.
 */
package org.mule.agent.registry;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.registry.DefaultRegistryBroker;
import org.mule.registry.MuleRegistryHelper;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transformer.builder.MockConverterBuilder;
import org.mule.transformer.types.DataTypeFactory;

@SmallTest
public class MuleRegistryHelperTransformersAsObjectsTestCase
extends AbstractMuleTestCase {
    private static final DataType<Apple> APPLE_DATA_TYPE = DataTypeFactory.create(Apple.class);
    private final DefaultRegistryBroker registry = (DefaultRegistryBroker)Mockito.mock(DefaultRegistryBroker.class);
    private final MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private final MuleRegistryHelper muleRegistryHelper = new MuleRegistryHelper(this.registry, this.muleContext);
    private final Converter stringToApple = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.STRING)).to(APPLE_DATA_TYPE)).build();
    private final Converter appleToString = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(APPLE_DATA_TYPE)).to(DataTypeFactory.STRING)).build();

    @Before
    public void setUp() throws Exception {
        TransformerResolver transformerResolver = (TransformerResolver)Mockito.mock(TransformerResolver.class);
        Mockito.when((Object)transformerResolver.resolve(DataTypeFactory.STRING, APPLE_DATA_TYPE)).thenReturn((Object)this.stringToApple);
        Mockito.when((Object)transformerResolver.resolve(APPLE_DATA_TYPE, DataTypeFactory.STRING)).thenReturn((Object)this.appleToString);
        this.muleRegistryHelper.registerObject("mockTransformerResolver", (Object)transformerResolver);
        this.muleRegistryHelper.registerObject("StringToAppleConverter", (Object)this.stringToApple);
        this.muleRegistryHelper.registerObject("AppleToStringConverter", (Object)this.appleToString, this.appleToString.getClass());
    }

    @Test
    public void testRegisterTransformersAsNamedObjects() throws Exception {
        Transformer transformer1 = this.muleRegistryHelper.lookupTransformer(DataTypeFactory.STRING, APPLE_DATA_TYPE);
        Transformer transformer2 = this.muleRegistryHelper.lookupTransformer(APPLE_DATA_TYPE, DataTypeFactory.STRING);
        Assert.assertEquals((Object)this.stringToApple, (Object)transformer1);
        Assert.assertEquals((Object)this.appleToString, (Object)transformer2);
    }
}

