/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.util.queue;

/**
 * Factory for a transient and persistent {@link QueueTransactionContext}
 */
public interface QueueTransactionContextFactory<T extends QueueTransactionContext>
{

    /**
     * @return a transaction context for persistent queues
     */
    T createPersistentTransactionContext();

    /**
     * @return a transaction context for transient queues
     */
    T createTransientTransactionContext();
}
