/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.xa;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.Xid;
import org.mule.util.xa.AbstractResourceManager;
import org.mule.util.xa.AbstractTransactionContext;

public abstract class AbstractXAResourceManager
extends AbstractResourceManager {
    protected Map<Xid, AbstractTransactionContext> suspendedContexts = new ConcurrentHashMap<Xid, AbstractTransactionContext>();
    protected Map<Xid, AbstractTransactionContext> activeContexts = new ConcurrentHashMap<Xid, AbstractTransactionContext>();

    protected boolean includeBranchInXid() {
        return true;
    }

    protected AbstractTransactionContext getTransactionalResource(Xid xid) {
        AbstractTransactionContext context = this.getActiveTransactionalResource(xid);
        if (context != null) {
            return context;
        }
        return this.getSuspendedTransactionalResource(xid);
    }

    AbstractTransactionContext getActiveTransactionalResource(Xid xid) {
        return this.activeContexts.get(xid);
    }

    AbstractTransactionContext getSuspendedTransactionalResource(Xid xid) {
        return this.suspendedContexts.get(xid);
    }

    void addActiveTransactionalResource(Xid xid, AbstractTransactionContext context) {
        this.activeContexts.put(xid, context);
    }

    void addSuspendedTransactionalResource(Xid xid, AbstractTransactionContext context) {
        this.suspendedContexts.put(xid, context);
    }

    void removeActiveTransactionalResource(Xid xid) {
        this.activeContexts.remove(xid);
    }

    void removeSuspendedTransactionalResource(Xid xid) {
        this.suspendedContexts.remove(xid);
    }
}

