/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.AttributeEvaluator;
import org.mule.util.WildcardAttributeEvaluator;

public class RemoveAttachmentTransformer
extends AbstractMessageTransformer {
    private AttributeEvaluator nameEvaluator;
    private WildcardAttributeEvaluator wildcardAttributeEvaluator;

    public RemoveAttachmentTransformer() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.nameEvaluator.initialize(this.muleContext.getExpressionManager());
    }

    @Override
    public Object transformMessage(final MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            if (this.wildcardAttributeEvaluator.hasWildcards()) {
                try {
                    this.wildcardAttributeEvaluator.processValues(message.getOutboundAttachmentNames(), new WildcardAttributeEvaluator.MatchCallback(){

                        @Override
                        public void processMatch(String matchedValue) {
                            try {
                                message.removeOutboundAttachment(matchedValue);
                            }
                            catch (Exception e) {
                                throw new MuleRuntimeException(e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    throw new TransformerException(this, (Throwable)e);
                }
            } else {
                Object keyValue = this.nameEvaluator.resolveValue(message);
                if (keyValue != null) {
                    String name = keyValue.toString();
                    message.removeOutboundAttachment(name);
                } else {
                    this.logger.info((Object)"Attachment key expression return null, no attachment will be removed");
                }
            }
            return message;
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        RemoveAttachmentTransformer clone = (RemoveAttachmentTransformer)super.clone();
        clone.setAttachmentName(this.nameEvaluator.getRawValue());
        return clone;
    }

    public void setAttachmentName(String attachmentName) {
        this.nameEvaluator = new AttributeEvaluator(attachmentName);
        this.wildcardAttributeEvaluator = new WildcardAttributeEvaluator(attachmentName);
    }
}

