/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.session.DefaultMuleSession;
import org.mule.util.ClassUtils;
import org.mule.util.store.DeserializationPostInitialisable;

public class EventGroup
implements Comparable<EventGroup>,
Serializable,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 953739659615692697L;
    public static final MuleEvent[] EMPTY_EVENTS_ARRAY = new MuleEvent[0];
    public static final String MULE_ARRIVAL_ORDER_PROPERTY = "MULE_ARRIVAL_ORDER";
    private transient ObjectStoreManager objectStoreManager = null;
    private final Object groupId;
    transient ListableObjectStore<MuleEvent> events;
    private final long created = System.currentTimeMillis();
    private final int expectedSize;
    private transient MuleContext muleContext;
    private final String storePrefix;
    private String commonRootId = null;
    private static boolean hasNoCommonRootId = false;
    private int arrivalOrderCounter = 0;
    public static final String DEFAULT_STORE_PREFIX = "DEFAULT_STORE";

    public EventGroup(Object groupId, MuleContext muleContext) {
        this(groupId, muleContext, -1, false, DEFAULT_STORE_PREFIX);
    }

    public EventGroup(Object groupId, MuleContext muleContext, int expectedSize, boolean storeIsPersistent, String storePrefix) {
        this.muleContext = muleContext;
        this.storePrefix = storePrefix;
        String storeKey = storePrefix + ".eventGroup." + groupId;
        this.events = (ListableObjectStore)this.getObjectStoreManager().getObjectStore(storeKey, storeIsPersistent);
        this.expectedSize = expectedSize;
        this.groupId = groupId;
    }

    @Override
    public int compareTo(EventGroup other) {
        Object otherId = other.getGroupId();
        if (this.groupId instanceof Comparable && otherId instanceof Comparable) {
            return ((Comparable)this.groupId).compareTo(otherId);
        }
        long diff = this.created - other.getCreated();
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventGroup)) {
            return false;
        }
        EventGroup other = (EventGroup)obj;
        if (this.groupId == null) {
            return other.groupId == null;
        }
        return this.groupId.equals(other.groupId);
    }

    public int hashCode() {
        return this.groupId.hashCode();
    }

    public Object getGroupId() {
        return this.groupId;
    }

    public Iterator<MuleEvent> iterator() throws ObjectStoreException {
        return this.iterator(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<MuleEvent> iterator(boolean sortByArrival) throws ObjectStoreException {
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            if (this.events.allKeys().isEmpty()) {
                return IteratorUtils.emptyIterator();
            }
            return IteratorUtils.arrayIterator((Object[])this.toArray(sortByArrival));
        }
    }

    public MuleEvent[] toArray() throws ObjectStoreException {
        return this.toArray(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent[] toArray(boolean sortByArrival) throws ObjectStoreException {
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            if (this.events.allKeys().isEmpty()) {
                return EMPTY_EVENTS_ARRAY;
            }
            List<Serializable> keys = this.events.allKeys();
            MuleEvent[] eventArray = new MuleEvent[keys.size()];
            for (int i = 0; i < keys.size(); ++i) {
                eventArray[i] = (MuleEvent)this.events.retrieve(keys.get(i));
            }
            if (sortByArrival) {
                Arrays.sort(eventArray, new ArrivalOrderEventComparator());
            }
            return eventArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(MuleEvent event) throws ObjectStoreException {
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            String key = event.getId() + event.getMessage().getCorrelationSequence();
            event.getMessage().setInvocationProperty(MULE_ARRIVAL_ORDER_PROPERTY, ++this.arrivalOrderCounter);
            this.events.store((Serializable)((Object)key), event);
            if (!hasNoCommonRootId) {
                String rootId = event.getMessage().getMessageRootId();
                if (this.commonRootId == null) {
                    this.commonRootId = rootId;
                } else if (!this.commonRootId.equals(rootId)) {
                    hasNoCommonRootId = true;
                    this.commonRootId = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEvent(MuleEvent event) throws ObjectStoreException {
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            this.events.remove((Serializable)((Object)event.getId()));
        }
    }

    public long getCreated() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            try {
                return this.events.allKeys().size();
            }
            catch (ObjectStoreException e) {
                return -1;
            }
        }
    }

    public int expectedSize() {
        return this.expectedSize;
    }

    public void clear() throws ObjectStoreException {
        this.getObjectStoreManager().disposeStore(this.events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        buf.append(ClassUtils.getSimpleName(this.getClass()));
        buf.append(" {");
        buf.append("id=").append(this.groupId);
        buf.append(", expected size=").append(this.expectedSize);
        try {
            ListableObjectStore<MuleEvent> listableObjectStore = this.events;
            synchronized (listableObjectStore) {
                int currentSize = this.events.allKeys().size();
                buf.append(", current events=").append(currentSize);
                if (currentSize > 0) {
                    buf.append(" [");
                    Iterator<Serializable> i = this.events.allKeys().iterator();
                    while (i.hasNext()) {
                        Serializable id = i.next();
                        buf.append(((MuleEvent)this.events.retrieve(id)).getMessage().getUniqueId());
                        if (!i.hasNext()) continue;
                        buf.append(", ");
                    }
                    buf.append(']');
                }
            }
        }
        catch (ObjectStoreException e) {
            buf.append("ObjectStoreException " + e + " caught:" + e.getMessage());
        }
        buf.append('}');
        return buf.toString();
    }

    public MuleMessageCollection toMessageCollection() throws ObjectStoreException {
        return this.toMessageCollection(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleMessageCollection toMessageCollection(boolean sortByArrival) throws ObjectStoreException {
        DefaultMessageCollection col = new DefaultMessageCollection(this.muleContext);
        ArrayList<MuleMessage> messages = new ArrayList<MuleMessage>();
        ListableObjectStore<MuleEvent> listableObjectStore = this.events;
        synchronized (listableObjectStore) {
            for (Serializable id : this.events.allKeys()) {
                MuleMessage message = ((MuleEvent)this.events.retrieve(id)).getMessage();
                messages.add(message);
            }
        }
        if (sortByArrival) {
            Collections.sort(messages, new ArrivalOrderMessageComparator());
        }
        col.addMessages(messages);
        return col;
    }

    public String getCommonRootId() {
        return this.commonRootId;
    }

    public MuleEvent getMessageCollectionEvent() {
        try {
            if (this.size() > 0) {
                DefaultMuleEvent muleEvent = new DefaultMuleEvent((MuleMessage)this.toMessageCollection(), (MuleEvent)this.events.retrieve(this.events.allKeys().get(0)), this.getMergedSession());
                if (this.getCommonRootId() != null) {
                    muleEvent.getMessage().setMessageRootId(this.commonRootId);
                }
                return muleEvent;
            }
            return VoidMuleEvent.getInstance();
        }
        catch (ObjectStoreException e) {
            return VoidMuleEvent.getInstance();
        }
    }

    protected MuleSession getMergedSession() throws ObjectStoreException {
        DefaultMuleSession session = new DefaultMuleSession(((MuleEvent)this.events.retrieve(this.events.allKeys().get(0))).getSession());
        for (Serializable key : this.events.allKeys()) {
            MuleEvent event = (MuleEvent)this.events.retrieve(key);
            for (String name : event.getSession().getPropertyNamesAsSet()) {
                session.setProperty(name, event.getSession().getProperty(name));
            }
        }
        return session;
    }

    private ObjectStoreManager getObjectStoreManager() {
        if (this.objectStoreManager == null) {
            this.objectStoreManager = (ObjectStoreManager)this.muleContext.getRegistry().get("_muleObjectStoreManager");
        }
        return this.objectStoreManager;
    }

    public void initAfterDeserialisation(MuleContext context) throws MuleException {
        this.muleContext = context;
        String storeKey = this.storePrefix + ".eventGroup." + this.groupId;
        this.events = (ListableObjectStore)this.getObjectStoreManager().getObjectStore(storeKey, true);
    }

    public boolean isInitialised() {
        return this.muleContext != null;
    }

    public final class ArrivalOrderEventComparator
    implements Comparator<MuleEvent> {
        @Override
        public int compare(MuleEvent event1, MuleEvent event2) {
            int val1 = event1.getMessage().getInvocationProperty(EventGroup.MULE_ARRIVAL_ORDER_PROPERTY, -1);
            int val2 = event2.getMessage().getInvocationProperty(EventGroup.MULE_ARRIVAL_ORDER_PROPERTY, -1);
            return val1 - val2;
        }
    }

    public final class ArrivalOrderMessageComparator
    implements Comparator<MuleMessage> {
        @Override
        public int compare(MuleMessage message1, MuleMessage message2) {
            int val1 = message1.getInvocationProperty(EventGroup.MULE_ARRIVAL_ORDER_PROPERTY, -1);
            int val2 = message2.getInvocationProperty(EventGroup.MULE_ARRIVAL_ORDER_PROPERTY, -1);
            return val1 - val2;
        }
    }
}

