/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class MessagePayloadExpressionEvaluator
implements ExpressionEvaluator,
MuleContextAware {
    public static final String NAME = "payload";
    public static final String BYTE_ARRAY = "byte[]";
    protected final transient Log logger = LogFactory.getLog(MessagePayloadExpressionEvaluator.class);
    protected MuleContext muleContext;

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public Object evaluate(String expression, MuleMessage message) {
        if (message == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)expression)) {
            return message.getPayload();
        }
        try {
            if (expression.equals(BYTE_ARRAY)) {
                return message.getPayload(DataType.BYTE_ARRAY_DATA_TYPE);
            }
            return message.getPayload(DataTypeFactory.create(ClassUtils.loadClass(expression, this.getClass())));
        }
        catch (TransformerException e) {
            throw new MuleRuntimeException(CoreMessages.failedToProcessExtractorFunction(expression), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new MuleRuntimeException(CoreMessages.failedToProcessExtractorFunction(expression), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

