/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.Serializable;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.QueueStore;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueManager;

public class QueueProfile {
    private int maxOutstandingMessages = 0;
    private QueueStore<Serializable> objectStore;

    public static QueueProfile newInstancePersistingToDefaultMemoryQueueStore(MuleContext muleContext) {
        return QueueProfile.newInstance("_defaultInMemoryQueueStore", muleContext);
    }

    public static QueueProfile newInstanceWithPersistentQueueStore(MuleContext muleContext) {
        return QueueProfile.newInstance("_defaultPersistentQueueStore", muleContext);
    }

    private static QueueProfile newInstance(String objectStoreKey, MuleContext muleContext) {
        QueueStore objectStore = (QueueStore)muleContext.getRegistry().lookupObject(objectStoreKey);
        return new QueueProfile(objectStore);
    }

    public QueueProfile(QueueStore<Serializable> objectStore) {
        this.objectStore = objectStore;
    }

    public QueueProfile(QueueProfile queueProfile) {
        this.maxOutstandingMessages = queueProfile.getMaxOutstandingMessages();
        this.objectStore = queueProfile.objectStore;
    }

    public QueueProfile(int maxOutstandingMessages, QueueStore<Serializable> objectStore) {
        this.maxOutstandingMessages = maxOutstandingMessages;
        this.objectStore = objectStore;
    }

    public int getMaxOutstandingMessages() {
        return this.maxOutstandingMessages;
    }

    public void setMaxOutstandingMessages(int maxOutstandingMessages) {
        this.maxOutstandingMessages = maxOutstandingMessages;
    }

    public QueueConfiguration configureQueue(MuleContext context, String component, QueueManager queueManager) throws InitialisationException {
        QueueConfiguration qc = this.toQueueConfiguration(context);
        queueManager.setQueueConfiguration(component, qc);
        return qc;
    }

    public QueueConfiguration toQueueConfiguration(MuleContext context) {
        if (this.objectStore instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.objectStore)).setMuleContext(context);
        }
        return new QueueConfiguration(context, this.maxOutstandingMessages, this.objectStore);
    }

    public ListableObjectStore<Serializable> getObjectStore() {
        return this.objectStore;
    }

    public void setQueueStore(QueueStore<Serializable> objectStore) {
        this.objectStore = objectStore;
    }

    public void addQueueStore(QueueStore<Serializable> objectStore) {
        this.objectStore = objectStore;
    }

    public String toString() {
        return "QueueProfile{maxOutstandingMessage=" + this.maxOutstandingMessages + ", storeType=" + this.objectStore.getClass() + "}";
    }
}

