/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.InterfaceBinding;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.component.BindingInvocationHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.OutboundPassThroughRouter;

public class DefaultInterfaceBinding
implements InterfaceBinding {
    protected static final Log logger = LogFactory.getLog(DefaultInterfaceBinding.class);
    private Class<?> interfaceClass;
    private String methodName;
    protected OutboundRouter outboundRouter;

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        OptimizedRequestContext.unsafeRewriteEvent(event.getMessage());
        return this.outboundRouter.process(RequestContext.getEvent());
    }

    @Override
    public void setInterface(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    @Override
    public Class<?> getInterface() {
        return this.interfaceClass;
    }

    @Override
    public String getMethod() {
        return this.methodName;
    }

    @Override
    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public Object createProxy(Object target) {
        try {
            Object proxy = Proxy.newProxyInstance(this.getInterface().getClassLoader(), new Class[]{this.getInterface()}, (InvocationHandler)new BindingInvocationHandler(this));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Have proxy?: " + (null != proxy)));
            }
            return proxy;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreateProxyFor(target), (Throwable)e);
        }
    }

    @Override
    public void setEndpoint(ImmutableEndpoint e) throws MuleException {
        if (!(e instanceof OutboundEndpoint)) {
            throw new IllegalArgumentException("An outbound endpoint is required for Interface binding");
        }
        this.outboundRouter = new OutboundPassThroughRouter();
        this.outboundRouter.addRoute((OutboundEndpoint)e);
        this.outboundRouter.setTransactionConfig(e.getTransactionConfig());
        this.outboundRouter.setMuleContext(e.getMuleContext());
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DefaultInterfaceBinding");
        sb.append("{method='").append(this.methodName).append('\'');
        sb.append(", interface=").append(this.interfaceClass);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public ImmutableEndpoint getEndpoint() {
        if (this.outboundRouter != null) {
            MessageProcessor target = this.outboundRouter.getRoutes().get(0);
            return target instanceof ImmutableEndpoint ? (ImmutableEndpoint)((Object)target) : null;
        }
        return null;
    }
}

