/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.journal.queue;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.transaction.xa.Xid;
import org.mule.api.MuleContext;
import org.mule.util.journal.queue.AbstractQueueTxJournalEntry;
import org.mule.util.xa.MuleXid;

public class XaQueueTxJournalEntry
extends AbstractQueueTxJournalEntry<Xid> {
    public XaQueueTxJournalEntry(Xid txId, byte operation, String queueName, Serializable value) {
        super(new MuleXid(txId), operation, queueName, value);
    }

    public XaQueueTxJournalEntry(Xid txId, byte operation) {
        super(new MuleXid(txId), operation);
    }

    public XaQueueTxJournalEntry(DataInputStream inputStream, MuleContext muleContext) throws IOException {
        super(inputStream, muleContext);
    }

    @Override
    protected Xid deserializeTxId(DataInputStream inputStream) throws IOException {
        byte globalTransactionIdSize = inputStream.readByte();
        byte[] globalTransactionId = new byte[globalTransactionIdSize];
        inputStream.read(globalTransactionId, 0, globalTransactionIdSize);
        byte branchQualifierIdSize = inputStream.readByte();
        byte[] branchQualifierId = new byte[branchQualifierIdSize];
        inputStream.read(branchQualifierId, 0, branchQualifierIdSize);
        int formadId = inputStream.readInt();
        return new MuleXid(formadId, globalTransactionId, branchQualifierId);
    }

    @Override
    protected void serializeTxId(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(((Xid)this.getTxId()).getGlobalTransactionId().length);
        outputStream.write(((Xid)this.getTxId()).getGlobalTransactionId());
        outputStream.writeByte(((Xid)this.getTxId()).getBranchQualifier().length);
        outputStream.write(((Xid)this.getTxId()).getBranchQualifier());
        outputStream.writeInt(((Xid)this.getTxId()).getFormatId());
    }
}

