/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.journal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.Preconditions;
import org.mule.util.journal.JournalEntry;
import org.mule.util.journal.JournalEntrySerializer;
import org.mule.util.journal.TransactionCompletePredicate;
import org.mule.util.journal.TransactionJournalFile;

public class TransactionJournal<T, K extends JournalEntry<T>> {
    private static final int MAXIMUM_LOG_FILE_ENTRIES = 50000;
    private transient Log logger = LogFactory.getLog(this.getClass());
    private final TransactionCompletePredicate transactionCompletePredicate;
    private TransactionJournalFile<T, K> currentLogFile;
    private TransactionJournalFile<T, K> notCurrentLogFile;

    public TransactionJournal(String logFilesDirectory, TransactionCompletePredicate transactionCompletePredicate, JournalEntrySerializer journalEntrySerializer) {
        File logFileDirectory = new File(logFilesDirectory);
        if (!logFileDirectory.exists()) {
            Preconditions.checkState(logFileDirectory.mkdirs(), "Could not created directory for queue transaction logger " + logFileDirectory);
        }
        File logFile1 = new File(logFileDirectory, "tx1.log");
        File logFile2 = new File(logFileDirectory, "tx2.log");
        this.logger.info((Object)String.format("Using files for tx logs %s and %s", logFile1.getAbsolutePath(), logFile2.getAbsolutePath()));
        this.currentLogFile = new TransactionJournalFile(logFile1, journalEntrySerializer);
        this.notCurrentLogFile = new TransactionJournalFile(logFile2, journalEntrySerializer);
        this.transactionCompletePredicate = transactionCompletePredicate;
    }

    public synchronized void logUpdateOperation(JournalEntry<T> journalEntry) {
        TransactionJournalFile logFile = this.determineLogFile(journalEntry.getTxId());
        logFile.logOperation(journalEntry);
    }

    public synchronized void logCheckpointOperation(JournalEntry<T> journalEntry) {
        TransactionJournalFile logFile = this.determineLogFile(journalEntry.getTxId());
        logFile.logOperation(journalEntry);
        if (this.transactionCompletePredicate.isTransactionComplete(journalEntry)) {
            logFile.clearEntriesForTransaction(journalEntry.getTxId());
        }
    }

    public Collection<K> getLogEntriesForTx(T txId) {
        TransactionJournalFile logFile = this.determineLogFile(txId);
        if (!logFile.containsTx(txId)) {
            return Collections.emptyList();
        }
        return logFile.getLogEntries(txId);
    }

    public Multimap<T, K> getAllLogEntries() {
        LinkedHashMultimap logEntries = LinkedHashMultimap.create();
        logEntries.putAll(this.currentLogFile.getAllLogEntries());
        logEntries.putAll(this.notCurrentLogFile.getAllLogEntries());
        return logEntries;
    }

    public synchronized void close() {
        this.currentLogFile.close();
        this.notCurrentLogFile.close();
    }

    public synchronized void clear() {
        this.currentLogFile.clear();
        this.notCurrentLogFile.clear();
    }

    private TransactionJournalFile determineLogFile(T txId) {
        if (this.currentLogFile.containsTx(txId)) {
            return this.currentLogFile;
        }
        if (this.notCurrentLogFile.containsTx(txId)) {
            return this.notCurrentLogFile;
        }
        if (this.currentLogFile.size() > 50000 && this.notCurrentLogFile.size() == 0) {
            TransactionJournalFile<T, K> aux = this.currentLogFile;
            this.currentLogFile = this.notCurrentLogFile;
            this.notCurrentLogFile = aux;
        }
        return this.currentLogFile;
    }
}

