/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.SessionHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.session.DefaultMuleSession;
import org.mule.transformer.codec.Base64Decoder;
import org.mule.transformer.codec.Base64Encoder;

public class LegacySessionHandler
implements SessionHandler {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private static Transformer encoder = new Base64Encoder();
    private static Transformer decoder = new Base64Decoder();

    @Override
    public MuleSession retrieveSessionInfoFromMessage(MuleMessage message) throws MuleException {
        DefaultMuleSession session = new DefaultMuleSession();
        String sessionId = (String)message.getInboundProperty("MULE_SESSION_ID");
        Object sessionHeader = message.getInboundProperty("MULE_SESSION");
        if (sessionId != null) {
            throw new IllegalStateException("This session handler does not know how to look up session information for session id: " + sessionId);
        }
        if (sessionHeader != null) {
            String sessionString;
            try {
                sessionString = new String((byte[])decoder.transform(sessionHeader), message.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                sessionString = new String((byte[])decoder.transform(sessionHeader));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Parsing session header: " + sessionString));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(sessionString, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String pair = stringTokenizer.nextToken();
                int i = pair.indexOf("=");
                if (i == -1) {
                    throw new IllegalArgumentException(CoreMessages.sessionValueIsMalformed(pair).toString());
                }
                String name = pair.substring(0, i).trim();
                String value = pair.substring(i + 1).trim();
                session.setProperty(name, (Serializable)((Object)value));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added MuleSession variable: " + pair));
            }
        }
        return session;
    }

    @Override
    public void retrieveSessionInfoFromMessage(MuleMessage message, MuleSession session) throws MuleException {
        session = this.retrieveSessionInfoFromMessage(message);
    }

    @Override
    public void storeSessionInfoToMessage(MuleSession session, MuleMessage message) throws MuleException {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getSessionIDKey()).append("=").append(session.getId());
        for (String key : session.getPropertyNamesAsSet()) {
            buf.append(";");
            buf.append(key).append("=").append(session.getProperty(key));
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)String.format("Adding property to session header: %s=%s", key, session.getProperty(key)));
        }
        String sessionString = buf.toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding session header to message: " + sessionString));
        }
        sessionString = (String)encoder.transform(sessionString);
        message.setOutboundProperty("MULE_SESSION", sessionString);
    }

    @Override
    public String getSessionIDKey() {
        return "ID";
    }
}

