/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.routing.Aggregator;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.service.Service;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.routing.correlation.EventCorrelator;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.util.concurrent.ThreadNameHelper;

public abstract class AbstractAggregator
extends AbstractInterceptingMessageProcessor
implements Initialisable,
MuleContextAware,
FlowConstructAware,
Aggregator,
Startable,
Stoppable,
Disposable {
    protected EventCorrelator eventCorrelator;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    protected MessageInfoMapping messageInfoMapping;
    private long timeout = 0L;
    private boolean failOnTimeout = true;
    protected boolean persistentStores;
    protected String storePrefix = null;

    @Override
    public void initialise() throws InitialisationException {
        Service service;
        if (this.messageInfoMapping == null) {
            this.messageInfoMapping = this.flowConstruct.getMessageInfoMapping();
        }
        if (this.storePrefix == null) {
            this.storePrefix = String.format("%s%s.%s.", ThreadNameHelper.getPrefix(this.muleContext), this.flowConstruct.getName(), this.getClass().getName());
        }
        this.eventCorrelator = new EventCorrelator(this.getCorrelatorCallback(this.muleContext), this.next, this.messageInfoMapping, this.muleContext, this.flowConstruct.getName(), this.persistentStores, this.storePrefix);
        if (this.flowConstruct instanceof Service && (service = (Service)this.flowConstruct).getAsyncReplyMessageSource().getMessageProcessors().contains(this)) {
            this.failOnTimeout = service.getAsyncReplyMessageSource().isFailOnTimeout();
        }
        this.eventCorrelator.setTimeout(this.timeout);
        this.eventCorrelator.setFailOnTimeout(this.isFailOnTimeout());
    }

    @Override
    public void start() throws MuleException {
        if (this.timeout != 0L) {
            this.eventCorrelator.start();
        }
    }

    @Override
    public void stop() throws MuleException {
        this.eventCorrelator.stop();
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected abstract EventCorrelatorCallback getCorrelatorCallback(MuleContext var1);

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent result = this.eventCorrelator.process(event);
        if (result == null || VoidMuleEvent.getInstance().equals(result)) {
            return result;
        }
        return this.processNext(result);
    }

    @Override
    public void expireAggregation(String groupId) throws MessagingException {
        this.eventCorrelator.forceGroupExpiry(groupId);
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    @Override
    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public void setMessageInfoMapping(MessageInfoMapping messageInfoMapping) {
        this.messageInfoMapping = messageInfoMapping;
    }

    public boolean isPersistentStores() {
        return this.persistentStores;
    }

    public void setPersistentStores(boolean persistentStores) {
        this.persistentStores = persistentStores;
    }

    public String getStorePrefix() {
        return this.storePrefix;
    }

    public void setStorePrefix(String storePrefix) {
        this.storePrefix = storePrefix;
    }

    @Override
    public void dispose() {
        this.eventCorrelator.dispose();
    }
}

