/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.strategy;

import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.processor.StageNameSource;
import org.mule.config.ChainedThreadingProfile;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.processor.strategy.SynchronousProcessingStrategy;
import org.mule.util.concurrent.ThreadNameHelper;

public class AsynchronousProcessingStrategy
implements ProcessingStrategy {
    protected Integer maxThreads;
    protected Integer minThreads;
    protected Integer maxBufferSize;
    protected Long threadTTL;
    protected Long threadWaitTimeout;
    protected Integer poolExhaustedAction;
    protected ProcessingStrategy synchronousProcessingStrategy = new SynchronousProcessingStrategy();

    @Override
    public void configureProcessors(List<MessageProcessor> processors, StageNameSource nameSource, MessageProcessorChainBuilder chainBuilder, MuleContext muleContext) {
        if (processors.size() > 0) {
            chainBuilder.chain(this.createAsyncMessageProcessor(nameSource, muleContext));
            this.synchronousProcessingStrategy.configureProcessors(processors, nameSource, chainBuilder, muleContext);
        }
    }

    protected AsyncInterceptingMessageProcessor createAsyncMessageProcessor(StageNameSource nameSource, MuleContext muleContext) {
        return new AsyncInterceptingMessageProcessor(this.createThreadingProfile(muleContext), this.getThreadPoolName(nameSource.getName(), muleContext), muleContext.getConfiguration().getShutdownTimeout());
    }

    protected ThreadingProfile createThreadingProfile(MuleContext muleContext) {
        ChainedThreadingProfile threadingProfile = new ChainedThreadingProfile(muleContext.getDefaultThreadingProfile());
        if (this.maxThreads != null) {
            threadingProfile.setMaxThreadsActive(this.maxThreads);
        }
        if (this.minThreads != null) {
            threadingProfile.setMaxThreadsIdle(this.minThreads);
        }
        if (this.maxBufferSize != null) {
            threadingProfile.setMaxBufferSize(this.maxBufferSize);
        }
        if (this.threadTTL != null) {
            threadingProfile.setThreadTTL(this.threadTTL);
        }
        if (this.threadWaitTimeout != null) {
            threadingProfile.setThreadWaitTimeout(this.threadWaitTimeout);
        }
        if (this.poolExhaustedAction != null) {
            threadingProfile.setPoolExhaustedAction(this.poolExhaustedAction);
        }
        threadingProfile.setMuleContext(muleContext);
        return threadingProfile;
    }

    protected String getThreadPoolName(String stageName, MuleContext muleContext) {
        return ThreadNameHelper.flow(muleContext, stageName);
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public void setMaxBufferSize(Integer maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public void setThreadTTL(Long threadTTL) {
        this.threadTTL = threadTTL;
    }

    public void setThreadWaitTimeout(Long threadWaitTimeout) {
        this.threadWaitTimeout = threadWaitTimeout;
    }

    public void setPoolExhaustedAction(Integer poolExhaustedAction) {
        this.poolExhaustedAction = poolExhaustedAction;
    }

    public Integer getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public Long getThreadTTL() {
        return this.threadTTL;
    }

    public Long getThreadWaitTimeout() {
        return this.threadWaitTimeout;
    }

    public Integer getPoolExhaustedAction() {
        return this.poolExhaustedAction;
    }
}

