/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.management.stats.Statistics;
import org.mule.management.stats.printers.SimplePrinter;

public class RouterStatistics
implements Statistics {
    private static final long serialVersionUID = 4540482357430845065L;
    public static final int TYPE_INBOUND = 1;
    public static final int TYPE_OUTBOUND = 2;
    public static final int TYPE_RESPONSE = 3;
    public static final int TYPE_BINDING = 4;
    private boolean enabled;
    private long notRouted;
    private long caughtInCatchAll;
    private long totalRouted;
    private long totalReceived;
    private Map routed;
    private int type;

    public synchronized void clear() {
        this.notRouted = 0L;
        this.totalRouted = 0L;
        this.totalReceived = 0L;
        this.caughtInCatchAll = 0L;
        this.routed.clear();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void logSummary() {
        this.logSummary(new SimplePrinter(System.out));
    }

    public void logSummary(PrintWriter printer) {
        printer.print(this);
    }

    public synchronized void setEnabled(boolean b) {
        this.enabled = b;
    }

    public RouterStatistics(int type) {
        this.type = type;
        this.routed = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRoutedMessage(Collection endpoints) {
        ArrayList list;
        if (endpoints == null || endpoints.isEmpty()) {
            return;
        }
        ArrayList arrayList = list = new ArrayList(endpoints);
        synchronized (arrayList) {
            for (int i = 0; i < list.size(); ++i) {
                this.incrementRoutedMessage(list.get(i));
            }
        }
    }

    public synchronized void incrementRoutedMessage(Object endpoint) {
        if (endpoint == null) {
            return;
        }
        String name = endpoint instanceof ImmutableEndpoint ? ((ImmutableEndpoint)endpoint).getName() : endpoint.toString();
        Long cpt = (Long)this.routed.get(name);
        long count = 0L;
        if (cpt != null) {
            count = cpt;
        }
        this.routed.put(name, new Long(++count));
        ++this.totalRouted;
        ++this.totalReceived;
    }

    public synchronized void incrementNoRoutedMessage() {
        ++this.notRouted;
        ++this.totalReceived;
    }

    public synchronized void incrementCaughtMessage() {
        ++this.caughtInCatchAll;
    }

    public final long getCaughtMessages() {
        return this.caughtInCatchAll;
    }

    public final long getNotRouted() {
        return this.notRouted;
    }

    public final long getTotalReceived() {
        return this.totalReceived;
    }

    public final long getTotalRouted() {
        return this.totalRouted;
    }

    public final long getRouted(String endpointName) {
        Long l = (Long)this.routed.get(endpointName);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public boolean isInbound() {
        return this.type == 1;
    }

    public Map getRouted() {
        return this.routed;
    }
}

