/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.ServiceType;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.service.TransportServiceDescriptor;

public class DefaultEndpointFactory
implements EndpointFactory {
    protected static final Log logger = LogFactory.getLog(DefaultEndpointFactory.class);
    public static final String ENDPOINT_REGISTRY_PREFIX = "endpoint:";
    protected MuleContext muleContext;

    @Override
    public InboundEndpoint getInboundEndpoint(String uri) throws MuleException {
        logger.debug((Object)("DefaultEndpointFactory request for inbound endpoint for uri: " + uri));
        EndpointBuilder endpointBuilder = this.lookupEndpointBuilder(uri);
        if (endpointBuilder == null) {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint from uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri, this.muleContext);
        }
        return this.getInboundEndpoint(endpointBuilder);
    }

    @Override
    public OutboundEndpoint getOutboundEndpoint(String uri) throws MuleException {
        logger.debug((Object)("DefaultEndpointFactory request for outbound endpoint for uri: " + uri));
        EndpointBuilder endpointBuilder = this.lookupEndpointBuilder(uri);
        if (endpointBuilder == null) {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint from uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri, this.muleContext);
        }
        return this.getOutboundEndpoint(endpointBuilder);
    }

    protected EndpointBuilder lookupEndpointBuilder(String endpointName) {
        logger.debug((Object)("Looking up EndpointBuilder with name:" + endpointName + " in registry"));
        EndpointBuilder endpointBuilder = this.muleContext.getRegistry().lookupEndpointBuilder(endpointName);
        if (endpointBuilder != null) {
            logger.debug((Object)("EndpointBuilder with name:" + endpointName + " FOUND"));
        }
        return endpointBuilder;
    }

    @Override
    public InboundEndpoint getInboundEndpoint(EndpointBuilder builder) throws MuleException {
        InboundEndpoint endpoint = builder.buildInboundEndpoint();
        return (InboundEndpoint)this.registerEndpoint(endpoint);
    }

    @Override
    public OutboundEndpoint getOutboundEndpoint(EndpointBuilder builder) throws MuleException {
        OutboundEndpoint endpoint = builder.buildOutboundEndpoint();
        return (OutboundEndpoint)this.registerEndpoint(endpoint);
    }

    protected ImmutableEndpoint registerEndpoint(ImmutableEndpoint endpoint) throws RegistrationException {
        ImmutableEndpoint registryEndpoint = (ImmutableEndpoint)this.muleContext.getRegistry().lookupObject(ENDPOINT_REGISTRY_PREFIX + endpoint.hashCode());
        if (registryEndpoint == null) {
            this.muleContext.getRegistry().registerObject(ENDPOINT_REGISTRY_PREFIX + endpoint.hashCode(), endpoint);
            registryEndpoint = endpoint;
        }
        return registryEndpoint;
    }

    @Override
    public EndpointBuilder getEndpointBuilder(String uri) throws MuleException {
        logger.debug((Object)("DefaultEndpointFactory request for endpoint builder for uri: " + uri));
        EndpointBuilder endpointBuilder = this.lookupEndpointBuilder(uri);
        if (endpointBuilder != null) {
            try {
                endpointBuilder = (EndpointBuilder)endpointBuilder.clone();
            }
            catch (Exception e) {
                throw new EndpointException(CoreMessages.failedToClone("global endpoint EndpointBuilder"), (Throwable)e);
            }
        } else {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint builder for uri");
            MuleEndpointURI epURI = new MuleEndpointURI(uri, this.muleContext);
            TransportServiceDescriptor tsd = (TransportServiceDescriptor)this.muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, epURI.getFullScheme(), null);
            endpointBuilder = tsd.createEndpointBuilder(uri);
        }
        return endpointBuilder;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public InboundEndpoint getInboundEndpoint(EndpointURI uri) throws MuleException {
        return (InboundEndpoint)this.getEndpoint(uri, new EndpointSource(){

            @Override
            public ImmutableEndpoint getEndpoint(EndpointBuilder builder) throws MuleException {
                return DefaultEndpointFactory.this.getInboundEndpoint(builder);
            }
        });
    }

    @Override
    public OutboundEndpoint getOutboundEndpoint(EndpointURI uri) throws MuleException {
        return (OutboundEndpoint)this.getEndpoint(uri, new EndpointSource(){

            @Override
            public ImmutableEndpoint getEndpoint(EndpointBuilder builder) throws MuleException {
                return DefaultEndpointFactory.this.getOutboundEndpoint(builder);
            }
        });
    }

    protected ImmutableEndpoint getEndpoint(EndpointURI uri, EndpointSource source) throws MuleException {
        logger.debug((Object)("DefaultEndpointFactory request for endpoint for: " + uri));
        EndpointBuilder endpointBuilder = null;
        if (uri.getEndpointName() != null) {
            endpointBuilder = this.lookupEndpointBuilder(uri.getEndpointName());
            if (endpointBuilder == null) {
                throw new IllegalArgumentException("The endpoint with name: " + uri.getEndpointName() + "was not found.");
            }
        } else {
            logger.debug((Object)"Named EndpointBuilder not found, creating endpoint from uri");
            endpointBuilder = new EndpointURIEndpointBuilder(uri);
        }
        return source.getEndpoint(endpointBuilder);
    }

    private static interface EndpointSource {
        public ImmutableEndpoint getEndpoint(EndpointBuilder var1) throws MuleException;
    }
}

