/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.Map;
import javax.activation.DataHandler;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.el.context.InboundAttachmentMapContext;
import org.mule.el.context.MessagePropertyMapContext;
import org.mule.el.context.OutboundAttachmentMapContext;
import org.mule.transport.NullPayload;

public class MessageContext {
    protected MuleMessage message;

    public MessageContext(MuleMessage message) {
        this.message = message;
    }

    public String getId() {
        return this.message.getUniqueId();
    }

    public String getRootId() {
        return this.message.getMessageRootId();
    }

    public String getCorrelationId() {
        return this.message.getCorrelationId();
    }

    public int getCorrelationSequence() {
        return this.message.getCorrelationSequence();
    }

    public int getCorrelationGroupSize() {
        return this.message.getCorrelationGroupSize();
    }

    public Object getReplyTo() {
        return this.message.getReplyTo();
    }

    public void setReplyTo(String replyTo) {
        this.message.setReplyTo(replyTo);
    }

    public DataType<?> getDataType() {
        return this.message.getDataType();
    }

    public Object getPayload() {
        if (NullPayload.getInstance().equals(this.message.getPayload())) {
            return null;
        }
        return this.message.getPayload();
    }

    public <T> T payloadAs(Class<T> type) throws TransformerException {
        return this.message.getPayload(type);
    }

    public Object payloadAs(DataType<?> dt) throws TransformerException {
        return this.message.getPayload(dt);
    }

    public void setPayload(Object payload) {
        this.message.setPayload(payload);
    }

    public Map<String, Object> getInboundProperties() {
        return new MessagePropertyMapContext(this.message, PropertyScope.INBOUND);
    }

    public Map<String, Object> getOutboundProperties() {
        return new MessagePropertyMapContext(this.message, PropertyScope.OUTBOUND);
    }

    public Map<String, DataHandler> getInboundAttachments() {
        return new InboundAttachmentMapContext(this.message);
    }

    public Map<String, DataHandler> getOutboundAttachments() {
        return new OutboundAttachmentMapContext(this.message);
    }

    public String toString() {
        return this.message.toString();
    }
}

