/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.util.Comparator;
import java.util.Iterator;
import org.mule.config.Preferred;
import org.mule.config.PreferredComparator;

public class PreferredObjectSelector<T> {
    private final Comparator<T> comparator = new Comparator<T>(){
        private PreferredComparator preferredComparator = new PreferredComparator();

        @Override
        public int compare(T candidate1, T candidate2) {
            Preferred preferred = candidate1.getClass().getAnnotation(Preferred.class);
            Preferred preferred1 = candidate2.getClass().getAnnotation(Preferred.class);
            return this.preferredComparator.compare(preferred, preferred1);
        }
    };

    public T select(Iterator<T> iterator) {
        Object preferred = null;
        if (iterator.hasNext()) {
            preferred = iterator.next();
            while (iterator.hasNext()) {
                T current = iterator.next();
                if (this.comparator.compare(preferred, current) != -1) continue;
                preferred = current;
            }
        }
        return preferred;
    }
}

