/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;

public abstract class AbstractObjectStore<T extends Serializable>
implements ObjectStore<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public boolean contains(Serializable key) throws ObjectStoreException {
        if (key == null) {
            throw new ObjectStoreException(CoreMessages.objectIsNull("key"));
        }
        return this.doContains(key);
    }

    protected abstract boolean doContains(Serializable var1) throws ObjectStoreException;

    @Override
    public void store(Serializable key, T value) throws ObjectStoreException {
        if (key == null) {
            throw new ObjectStoreException(CoreMessages.objectIsNull("key"));
        }
        if (this.contains(key)) {
            throw new ObjectAlreadyExistsException();
        }
        this.doStore(key, value);
    }

    protected abstract void doStore(Serializable var1, T var2) throws ObjectStoreException;

    @Override
    public T retrieve(Serializable key) throws ObjectStoreException {
        if (key == null) {
            throw new ObjectStoreException(CoreMessages.objectIsNull("key"));
        }
        if (!this.contains(key)) {
            String message = "Key does not exist: " + key;
            throw new ObjectDoesNotExistException(CoreMessages.createStaticMessage(message));
        }
        return this.doRetrieve(key);
    }

    protected abstract T doRetrieve(Serializable var1) throws ObjectStoreException;

    @Override
    public T remove(Serializable key) throws ObjectStoreException {
        if (key == null) {
            throw new ObjectStoreException(CoreMessages.objectIsNull("key"));
        }
        if (!this.contains(key)) {
            throw new ObjectDoesNotExistException();
        }
        return this.doRemove(key);
    }

    protected abstract T doRemove(Serializable var1) throws ObjectStoreException;
}

