/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.regex.Pattern;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;

public class AttributeEvaluator {
    private static final Pattern SINGLE_EXPRESSION_REGEX_PATTERN = Pattern.compile("^#\\[(?:(?!#\\[).)*\\]$");
    private final String attributeValue;
    private ExpressionManager expressionManager;
    private AttributeType attributeType;

    public AttributeEvaluator(String attributeValue) {
        this.attributeValue = attributeValue;
    }

    public void initialize(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        this.resolveAttributeType();
    }

    private void resolveAttributeType() {
        this.attributeType = this.isSingleExpression(this.attributeValue) ? AttributeType.EXPRESSION : AttributeType.STRING;
    }

    private boolean isSingleExpression(String expression) {
        return expression != null && SINGLE_EXPRESSION_REGEX_PATTERN.matcher(expression).matches();
    }

    public boolean isExpression() {
        return this.attributeType.equals((Object)AttributeType.EXPRESSION);
    }

    public boolean isString() {
        return this.attributeType.equals((Object)AttributeType.STRING);
    }

    public Object resolveValue(MuleMessage message) {
        if (this.isExpression()) {
            return this.expressionManager.evaluate(this.attributeValue, message);
        }
        return this.expressionManager.parse(this.attributeValue, message);
    }

    public String getRawValue() {
        return this.attributeValue;
    }

    private static enum AttributeType {
        EXPRESSION,
        STRING;

    }
}

