/*
 * Decompiled with CFR 0.152.
 */
package org.mule.object;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationCallback;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceAware;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;

public abstract class AbstractObjectFactory
implements ObjectFactory,
FlowConstructAware {
    public static final String ATTRIBUTE_OBJECT_CLASS_NAME = "objectClassName";
    public static final String ATTRIBUTE_OBJECT_CLASS = "objectClass";
    protected String objectClassName;
    protected Class<?> objectClass;
    protected Map properties = null;
    protected List<InitialisationCallback> initialisationCallbacks = new ArrayList<InitialisationCallback>();
    protected FlowConstruct flowConstruct;
    protected boolean disposed = false;
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public AbstractObjectFactory() {
    }

    public AbstractObjectFactory(String objectClassName) {
        this(objectClassName, null);
    }

    public AbstractObjectFactory(String objectClassName, Map properties) {
        this.objectClassName = objectClassName;
        this.properties = properties;
        this.setupObjectClassFromObjectClassName();
    }

    public AbstractObjectFactory(Class<?> objectClass) {
        this(objectClass, null);
    }

    public AbstractObjectFactory(Class<?> objectClass, Map properties) {
        this.objectClassName = objectClass.getName();
        this.objectClass = objectClass;
        this.properties = properties;
    }

    protected Class<?> setupObjectClassFromObjectClassName() {
        try {
            Class klass;
            this.objectClass = klass = ClassUtils.getClass((String)this.objectClassName);
            return klass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.objectClassName == null || this.objectClass == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Object factory has not been initialized."), (Initialisable)this);
        }
        this.disposed = false;
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @Override
    public Object getInstance(MuleContext muleContext) throws Exception {
        if (this.objectClass == null || this.disposed) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Object factory has not been initialized."), (Initialisable)this);
        }
        Object object = ClassUtils.instanciateClass(this.objectClass, new Object[0]);
        if (this.properties != null) {
            BeanUtils.populateWithoutFail(object, this.properties, true);
        }
        if (object instanceof FlowConstructAware) {
            ((FlowConstructAware)object).setFlowConstruct(this.flowConstruct);
        }
        if (object instanceof ServiceAware && this.flowConstruct instanceof Service) {
            ((ServiceAware)object).setService((Service)this.flowConstruct);
        }
        if (this.isAutoWireObject()) {
            muleContext.getRegistry().applyProcessors(object);
        }
        this.fireInitialisationCallbacks(object);
        return object;
    }

    protected void fireInitialisationCallbacks(Object component) throws InitialisationException {
        for (InitialisationCallback callback : this.initialisationCallbacks) {
            callback.initialise(component);
        }
    }

    @Override
    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class<?> objectClass) {
        this.objectClass = objectClass;
        this.objectClassName = objectClass.getName();
    }

    protected String getObjectClassName() {
        return this.objectClassName;
    }

    public void setObjectClassName(String objectClassName) {
        this.objectClassName = objectClassName;
        this.setupObjectClassFromObjectClassName();
    }

    protected Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    @Override
    public void addObjectInitialisationCallback(InitialisationCallback callback) {
        this.initialisationCallbacks.add(callback);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public boolean isExternallyManagedLifecycle() {
        return false;
    }

    @Override
    public boolean isAutoWireObject() {
        return true;
    }
}

