/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.endpoint.ImmutableEndpoint;

public class EndpointMessageNotification
extends ServerNotification {
    private static final long serialVersionUID = -5118299601117624094L;
    protected static final Log logger = LogFactory.getLog(EndpointMessageNotification.class);
    public static final int MESSAGE_RECEIVED = 801;
    public static final int MESSAGE_DISPATCH_BEGIN = 802;
    public static final int MESSAGE_SEND_BEGIN = 803;
    public static final int MESSAGE_REQUEST_BEGIN = 804;
    public static final int MESSAGE_RESPONSE = 805;
    public static final int MESSAGE_DISPATCH_END = 851;
    public static final int MESSAGE_SEND_END = 852;
    public static final int MESSAGE_REQUEST_END = 853;
    public static final int MESSAGE_DISPATCHED = 802;
    public static final int MESSAGE_SENT = 803;
    public static final int MESSAGE_REQUESTED = 853;
    private String endpoint;
    private ImmutableEndpoint immutableEndpoint;
    private FlowConstruct flowConstruct;

    public EndpointMessageNotification(MuleMessage resource, ImmutableEndpoint endpoint, FlowConstruct flowConstruct, int action) {
        super(EndpointMessageNotification.cloneMessage(resource), action);
        this.resourceIdentifier = flowConstruct != null ? flowConstruct.getName() : null;
        this.endpoint = endpoint.getEndpointURI().toString();
        this.immutableEndpoint = endpoint;
        this.flowConstruct = flowConstruct;
    }

    @Override
    protected String getPayloadToString() {
        try {
            return ((MuleMessage)this.source).getPayloadAsString();
        }
        catch (Exception e) {
            return this.source.toString();
        }
    }

    @Override
    public String toString() {
        return this.EVENT_NAME + "{action=" + EndpointMessageNotification.getActionName(this.action) + ", endpoint: " + this.endpoint + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + ", serverId=" + this.serverId + ", message: " + this.source + "}";
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public ImmutableEndpoint getImmutableEndpoint() {
        return this.immutableEndpoint;
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public String getType() {
        return "trace";
    }

    @Override
    public MuleMessage getSource() {
        return (MuleMessage)super.getSource();
    }

    static {
        EndpointMessageNotification.registerAction("receive", 801);
        EndpointMessageNotification.registerAction("response", 805);
        EndpointMessageNotification.registerAction("begin dispatch", 802);
        EndpointMessageNotification.registerAction("begin send", 803);
        EndpointMessageNotification.registerAction("begin request", 804);
        EndpointMessageNotification.registerAction("end dispatch", 851);
        EndpointMessageNotification.registerAction("end send", 852);
        EndpointMessageNotification.registerAction("end request", 853);
    }
}

