/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.util.List;
import org.apache.commons.lang.Validate;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.AbstractConfigurationPattern;

public class Bridge
extends AbstractConfigurationPattern {
    private final OutboundEndpoint outboundEndpoint;
    private final MessageExchangePattern exchangePattern;
    private final boolean transacted;

    public Bridge(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, List<MessageProcessor> transformers, List<MessageProcessor> responseTransformers, MessageExchangePattern exchangePattern, boolean transacted) {
        super(name, muleContext, transformers, responseTransformers);
        Validate.notNull((Object)messageSource, (String)"messageSource can't be null");
        Validate.notNull((Object)outboundEndpoint, (String)"outboundEndpoint can't be null");
        Validate.notNull((Object)((Object)exchangePattern), (String)"exchangePattern can't be null");
        this.messageSource = messageSource;
        this.outboundEndpoint = outboundEndpoint;
        this.exchangePattern = exchangePattern;
        this.transacted = transacted;
    }

    @Override
    protected void configureMessageProcessorsBeforeTransformation(MessageProcessorChainBuilder builder) {
    }

    @Override
    protected void configureMessageProcessorsAfterTransformation(MessageProcessorChainBuilder builder) {
        builder.chain(this.outboundEndpoint);
    }

    @Override
    protected void validateConstruct() throws FlowConstructInvalidException {
        super.validateConstruct();
        if (this.messageSource instanceof InboundEndpoint) {
            this.validateInboundEndpoint((InboundEndpoint)this.messageSource);
        }
        this.validateOutboundEndpoint();
    }

    private void validateOutboundEndpoint() throws FlowConstructInvalidException {
        if (this.outboundEndpoint.getExchangePattern() != this.exchangePattern) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("Inconsistent bridge outbound endpoint exchange pattern, expected " + (Object)((Object)this.exchangePattern) + " but was " + (Object)((Object)this.outboundEndpoint.getExchangePattern())), this);
        }
        if (this.transacted && (this.outboundEndpoint.getTransactionConfig() == null || !this.outboundEndpoint.getTransactionConfig().isConfigured())) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("A transacted bridge requires a transacted outbound endpoint"), this);
        }
        if (!this.transacted && this.outboundEndpoint.getTransactionConfig() != null && this.outboundEndpoint.getTransactionConfig().isConfigured()) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("A non-transacted bridge requires a non-transacted outbound endpoint"), this);
        }
    }

    private void validateInboundEndpoint(InboundEndpoint inboundEndpoint) throws FlowConstructInvalidException {
        if (inboundEndpoint.getExchangePattern() != this.exchangePattern) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("Inconsistent bridge inbound endpoint exchange pattern, expected " + (Object)((Object)this.exchangePattern) + " but was " + (Object)((Object)inboundEndpoint.getExchangePattern())), this);
        }
        if (this.transacted && (inboundEndpoint.getTransactionConfig() == null || !inboundEndpoint.getTransactionConfig().isConfigured())) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("A transacted bridge requires a transacted inbound endpoint"), this);
        }
        if (!this.transacted && inboundEndpoint.getTransactionConfig() != null && inboundEndpoint.getTransactionConfig().isConfigured()) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("A non-transacted bridge requires a non-transacted inbound endpoint"), this);
        }
    }

    @Override
    public String getConstructType() {
        return "Bridge";
    }
}

