/*
 * Decompiled with CFR 0.152.
 */
package org.mule.agent;

import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.agent.AbstractNotificationLoggerAgent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;

public class EndpointNotificationLoggerAgent
extends AbstractNotificationLoggerAgent {
    private OutboundEndpoint endpoint = null;
    private List<Integer> ignoredNotifications = new ArrayList<Integer>();

    public EndpointNotificationLoggerAgent() {
        super("Endpoint Logger Agent");
        this.ignoredNotifications.add(106);
        this.ignoredNotifications.add(107);
        this.ignoredNotifications.add(108);
        this.ignoredNotifications.add(208);
        this.ignoredNotifications.add(210);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        try {
            if (this.endpoint == null) {
                throw new InitialisationException(CoreMessages.propertiesNotSet("endpoint"), (Initialisable)this);
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    protected void logEvent(ServerNotification e) {
        if (this.endpoint != null && !this.ignoredNotifications.contains(new Integer(e.getAction()))) {
            if (!this.endpoint.getConnector().isStarted()) {
                this.logger.warn((Object)("Endpoint not started: " + this.endpoint.getEndpointURI() + ". Cannot dispatch notification: " + e));
                return;
            }
            if ((e.getAction() == 702 || e.getAction() == 703) && e.getSource().equals(this.endpoint.getConnector())) {
                return;
            }
            DefaultMuleMessage msg = new DefaultMuleMessage(e, this.muleContext);
            try {
                if (this.endpoint.getFilter() != null && !this.endpoint.getFilter().accept(msg)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Message not accepted with filter: " + this.endpoint.getFilter()));
                    }
                    return;
                }
                DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)msg, this.endpoint.getExchangePattern(), (FlowConstruct)null);
                event.setEnableNotifications(false);
                this.endpoint.process(event);
            }
            catch (Exception e1) {
                this.logger.error((Object)("Failed to dispatch event: " + e.toString() + " over endpoint: " + this.endpoint + ". Error is: " + e1.getMessage()), (Throwable)e1);
            }
        }
    }

    @Override
    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName()).append(": ");
        if (this.endpoint != null) {
            buf.append("Forwarding notifications to: ").append(this.endpoint.getEndpointURI().getAddress());
        }
        return buf.toString();
    }

    public OutboundEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(OutboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }
}

