/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.Validate;
import org.mule.routing.AbstractMessageSequence;

public final class CollectionMessageSequence<T>
extends AbstractMessageSequence<T> {
    private final Iterator<T> iter;
    private int remaining;

    public CollectionMessageSequence(Collection<T> collection) {
        Validate.notNull(collection);
        this.iter = collection.iterator();
        this.remaining = collection.size();
    }

    @Override
    public int size() {
        return this.remaining;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public T next() {
        T next = this.iter.next();
        --this.remaining;
        return next;
    }
}

