/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.mule.api.MuleContext;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.transaction.ExternalTransactionAwareTransactionFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transaction.TransactionFactory;
import org.mule.execution.ExecutionInterceptor;
import org.mule.transaction.TransactionCoordination;

class ExternalTransactionInterceptor<T>
implements ExecutionInterceptor<T> {
    private final ExecutionInterceptor<T> next;
    private TransactionConfig transactionConfig;
    private MuleContext muleContext;

    public ExternalTransactionInterceptor(ExecutionInterceptor<T> next, TransactionConfig transactionConfig, MuleContext muleContext) {
        this.next = next;
        this.transactionConfig = transactionConfig;
        this.muleContext = muleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T execute(ExecutionCallback<T> callback) throws Exception {
        Transaction joinedExternal = null;
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            TransactionFactory tmFactory;
            if (tx == null && this.muleContext != null && this.transactionConfig != null && this.transactionConfig.isInteractWithExternal() && (tmFactory = this.transactionConfig.getFactory()) instanceof ExternalTransactionAwareTransactionFactory) {
                ExternalTransactionAwareTransactionFactory externalTransactionFactory = (ExternalTransactionAwareTransactionFactory)tmFactory;
                joinedExternal = tx = externalTransactionFactory.joinExternalTransaction(this.muleContext);
            }
            T t = this.next.execute(callback);
            return t;
        }
        finally {
            if (joinedExternal != null) {
                TransactionCoordination.getInstance().unbindTransaction(joinedExternal);
            }
        }
    }
}

