/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.security.SecurityException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.util.StreamCloserService;
import org.mule.config.ExceptionHelper;
import org.mule.context.notification.ExceptionNotification;
import org.mule.context.notification.SecurityNotification;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.management.stats.ServiceStatistics;
import org.mule.message.ExceptionMessage;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.routing.filters.WildcardFilter;
import org.mule.routing.outbound.MulticastingRouter;
import org.mule.transaction.TransactionCoordination;
import org.mule.util.CollectionUtils;

public abstract class AbstractExceptionListener
extends AbstractMessageProcessorOwner {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List<MessageProcessor> messageProcessors = new CopyOnWriteArrayList<MessageProcessor>();
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected WildcardFilter rollbackTxFilter;
    protected WildcardFilter commitTxFilter;
    protected boolean enableNotifications = true;

    protected boolean isRollback(Throwable t) {
        t = ExceptionHelper.getRootException(t);
        if (this.rollbackTxFilter == null && this.commitTxFilter == null) {
            return true;
        }
        return this.rollbackTxFilter != null && this.rollbackTxFilter.accept(t.getClass().getName()) || this.commitTxFilter != null && !this.commitTxFilter.accept(t.getClass().getName());
    }

    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public void setMessageProcessors(List<MessageProcessor> processors) {
        if (processors == null) {
            throw new IllegalArgumentException("List of targets = null");
        }
        this.messageProcessors.clear();
        this.messageProcessors.addAll(processors);
    }

    public void addEndpoint(MessageProcessor processor) {
        if (processor != null) {
            this.messageProcessors.add(processor);
        }
    }

    public boolean removeMessageProcessor(MessageProcessor processor) {
        return this.messageProcessors.remove(processor);
    }

    protected Throwable getExceptionType(Throwable t, Class exceptionType) {
        while (t != null) {
            if (exceptionType.isAssignableFrom(t.getClass())) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }

    @Override
    public final synchronized void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            super.initialise();
            this.doInitialise(this.muleContext);
            this.initialised.set(true);
        }
    }

    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        this.logger.info((Object)("Initialising exception listener: " + this.toString()));
    }

    protected void fireNotification(Exception ex) {
        if (this.enableNotifications) {
            if (ex instanceof SecurityException) {
                this.fireNotification(new SecurityNotification((SecurityException)ex, 401));
            } else {
                this.fireNotification(new ExceptionNotification(ex));
            }
        }
    }

    protected void routeException(MuleEvent event, Throwable t) {
        if (!this.messageProcessors.isEmpty()) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Message being processed is: " + event.getMessage().getPayloadForLogging()));
                }
                String component = "Unknown";
                if (event.getFlowConstruct() != null) {
                    component = event.getFlowConstruct().getName();
                }
                URI endpointUri = event.getMessageSourceURI();
                ExceptionMessage msg = new ExceptionMessage(event, t, component, endpointUri);
                DefaultMuleMessage exceptionMessage = new DefaultMuleMessage((Object)msg, event.getMessage(), this.muleContext);
                MulticastingRouter router = new MulticastingRouter(){

                    @Override
                    protected void setMessageProperties(FlowConstruct session, MuleMessage message, MessageProcessor target) {
                    }
                };
                router.setRoutes(this.getMessageProcessors());
                router.setMuleContext(this.muleContext);
                router.route(new DefaultMuleEvent(exceptionMessage, event));
            }
            catch (Exception e) {
                this.logFatal(event, e);
            }
        }
        this.processOutboundRouterStatistics(event.getFlowConstruct());
    }

    @Deprecated
    protected void routeException(MuleEvent event, MessageProcessor target, Throwable t) {
        this.routeException(event, t);
    }

    protected void rollback(RollbackSourceCallback rollbackMethod) {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null) {
            try {
                tx.rollback();
            }
            catch (TransactionException e) {
                this.logger.error((Object)e);
            }
        } else if (rollbackMethod != null) {
            rollbackMethod.rollback();
        }
    }

    protected void closeStream(MuleMessage message) {
        if (this.muleContext == null || this.muleContext.isDisposing() || this.muleContext.isDisposed()) {
            return;
        }
        if (message != null && this.muleContext.getRegistry().lookupObject("_muleStreamCloserService") != null) {
            ((StreamCloserService)this.muleContext.getRegistry().lookupObject("_muleStreamCloserService")).closeStream(message.getPayload());
        }
    }

    protected void logException(Throwable t) {
        MuleException muleException = ExceptionHelper.getRootMuleException(t);
        if (muleException != null) {
            this.logger.error((Object)muleException.getDetailedMessage());
        } else {
            this.logger.error((Object)("Caught exception in Exception Strategy: " + t.getMessage()), t);
        }
    }

    protected void logFatal(MuleEvent event, Throwable t) {
        FlowConstructStatistics statistics = event.getFlowConstruct().getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incFatalError();
        }
        this.logger.fatal((Object)("Failed to dispatch message to error queue after it failed to process.  This may cause message loss." + (event.getMessage() == null ? "" : "Logging Message here: \n" + event.getMessage().toString())), t);
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    protected void fireNotification(ServerNotification notification) {
        if (this.muleContext != null) {
            this.muleContext.fireNotification(notification);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.debug((Object)("MuleContext is not yet available for firing notifications, ignoring event: " + notification));
        }
    }

    public WildcardFilter getCommitTxFilter() {
        return this.commitTxFilter;
    }

    public void setCommitTxFilter(WildcardFilter commitTxFilter) {
        this.commitTxFilter = commitTxFilter;
    }

    public boolean isEnableNotifications() {
        return this.enableNotifications;
    }

    public void setEnableNotifications(boolean enableNotifications) {
        this.enableNotifications = enableNotifications;
    }

    public WildcardFilter getRollbackTxFilter() {
        return this.rollbackTxFilter;
    }

    public void setRollbackTxFilter(WildcardFilter rollbackTxFilter) {
        this.rollbackTxFilter = rollbackTxFilter;
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return this.messageProcessors;
    }

    @Deprecated
    protected void rollbackTransaction() {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (TransactionException e) {
            this.logException(e);
        }
    }

    @Deprecated
    protected void handleTransaction(Throwable t) {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx == null) {
            return;
        }
        t = ExceptionHelper.getRootException(t);
        boolean transactionRollback = false;
        if (this.rollbackTxFilter == null && this.commitTxFilter == null) {
            this.rollbackTransaction();
            transactionRollback = true;
        } else if (this.rollbackTxFilter != null && this.rollbackTxFilter.accept(t.getClass().getName())) {
            this.rollbackTransaction();
            transactionRollback = true;
        } else if (this.commitTxFilter != null && !this.commitTxFilter.accept(t.getClass().getName())) {
            this.rollbackTransaction();
            transactionRollback = true;
        }
        if (transactionRollback && t instanceof MessagingException) {
            ((MessagingException)t).setCauseRollback(true);
        }
    }

    protected void commit() {
        TransactionCoordination.getInstance().commitCurrentTransaction();
    }

    protected void rollback(Exception ex) {
        if (TransactionCoordination.getInstance().getTransaction() != null) {
            TransactionCoordination.getInstance().rollbackCurrentTransaction();
        }
        if (ex instanceof MessagingException) {
            MessagingException messagingException = (MessagingException)ex;
            messagingException.setCauseRollback(true);
        }
    }

    void processOutboundRouterStatistics(FlowConstruct flowConstruct) {
        List<MessageProcessor> processors = this.getMessageProcessors();
        FlowConstructStatistics statistics = flowConstruct.getStatistics();
        if (CollectionUtils.isNotEmpty(processors) && statistics instanceof ServiceStatistics && statistics.isEnabled()) {
            for (MessageProcessor endpoint : processors) {
                ((ServiceStatistics)statistics).getOutboundRouterStat().incrementRoutedMessage(endpoint);
            }
        }
    }
}

