/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.component.InterfaceBinding;
import org.mule.api.component.JavaComponent;
import org.mule.api.component.LifecycleAdapter;
import org.mule.api.component.LifecycleAdapterFactory;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.object.ObjectFactory;
import org.mule.api.service.Service;
import org.mule.component.AbstractComponent;
import org.mule.component.DefaultComponentLifecycleAdapterFactory;
import org.mule.component.NullLifecycleAdapter;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.DefaultEntryPointResolverSet;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;

public abstract class AbstractJavaComponent
extends AbstractComponent
implements JavaComponent {
    protected EntryPointResolverSet entryPointResolverSet;
    protected List<InterfaceBinding> bindings = new ArrayList<InterfaceBinding>();
    protected ObjectFactory objectFactory;
    protected LifecycleAdapterFactory lifecycleAdapterFactory;

    public AbstractJavaComponent() {
    }

    public AbstractJavaComponent(ObjectFactory objectFactory) {
        this(objectFactory, null, null);
    }

    public AbstractJavaComponent(ObjectFactory objectFactory, EntryPointResolverSet entryPointResolverSet, List<InterfaceBinding> bindings) {
        this.objectFactory = objectFactory;
        this.entryPointResolverSet = entryPointResolverSet;
        if (bindings != null) {
            this.bindings = bindings;
        }
    }

    @Override
    protected Object doInvoke(MuleEvent event) throws Exception {
        return this.invokeComponentInstance(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeComponentInstance(MuleEvent event) throws Exception {
        LifecycleAdapter componentLifecycleAdapter = null;
        try {
            componentLifecycleAdapter = this.borrowComponentLifecycleAdaptor();
            Object object = componentLifecycleAdapter.invoke(event);
            return object;
        }
        finally {
            if (componentLifecycleAdapter != null) {
                this.returnComponentLifecycleAdaptor(componentLifecycleAdapter);
            }
        }
    }

    @Override
    public Class<?> getObjectType() {
        return this.objectFactory.getObjectClass();
    }

    protected LifecycleAdapter createLifecycleAdaptor() throws Exception {
        Object object = this.objectFactory.getInstance(this.muleContext);
        LifecycleAdapter lifecycleAdapter = this.lifecycleAdapterFactory != null ? this.lifecycleAdapterFactory.create(object, this, this.flowConstruct, this.entryPointResolverSet, this.muleContext) : (this.objectFactory.isExternallyManagedLifecycle() ? new NullLifecycleAdapter(object, this, this.flowConstruct, this.entryPointResolverSet, this.muleContext) : (this.flowConstruct instanceof Service ? ((Service)this.flowConstruct).getModel().getLifecycleAdapterFactory().create(object, this, this.flowConstruct, this.entryPointResolverSet, this.muleContext) : new DefaultComponentLifecycleAdapterFactory().create(object, this, this.flowConstruct, this.entryPointResolverSet, this.muleContext)));
        lifecycleAdapter.initialise();
        return lifecycleAdapter;
    }

    protected abstract LifecycleAdapter borrowComponentLifecycleAdaptor() throws Exception;

    protected abstract void returnComponentLifecycleAdaptor(LifecycleAdapter var1) throws Exception;

    @Override
    protected void doInitialise() throws InitialisationException {
        if (this.objectFactory == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("object factory"), (Initialisable)this);
        }
        this.objectFactory.initialise();
    }

    @Override
    protected void doStart() throws MuleException {
        if (this.entryPointResolverSet == null) {
            this.entryPointResolverSet = this.flowConstruct instanceof Service ? ((Service)this.flowConstruct).getModel().getEntryPointResolverSet() : new LegacyEntryPointResolverSet();
        }
    }

    @Override
    protected void doDispose() {
        if (this.objectFactory != null) {
            this.objectFactory.dispose();
        }
    }

    @Override
    public EntryPointResolverSet getEntryPointResolverSet() {
        return this.entryPointResolverSet;
    }

    @Override
    public List<InterfaceBinding> getInterfaceBindings() {
        return this.bindings;
    }

    @Override
    public void setEntryPointResolverSet(EntryPointResolverSet entryPointResolverSet) {
        this.entryPointResolverSet = entryPointResolverSet;
    }

    @Override
    public void setInterfaceBindings(List<InterfaceBinding> bindings) {
        this.bindings = bindings;
    }

    public void setEntryPointResolvers(Collection<EntryPointResolver> entryPointResolvers) {
        if (null == this.entryPointResolverSet) {
            this.entryPointResolverSet = new DefaultEntryPointResolverSet();
        }
        for (EntryPointResolver resolver : entryPointResolvers) {
            this.entryPointResolverSet.addEntryPointResolver(resolver);
        }
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.injectService();
    }

    @Override
    public LifecycleAdapterFactory getLifecycleAdapterFactory() {
        return this.lifecycleAdapterFactory;
    }

    @Override
    public void setLifecycleAdapterFactory(LifecycleAdapterFactory lifecycleAdapterFactory) {
        this.lifecycleAdapterFactory = lifecycleAdapterFactory;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
        this.injectService();
    }

    protected void injectService() {
        if (this.objectFactory != null && this.objectFactory instanceof FlowConstructAware && this.flowConstruct != null) {
            ((FlowConstructAware)((Object)this.objectFactory)).setFlowConstruct(this.flowConstruct);
        }
    }
}

