/*
 * Decompiled with CFR 0.152.
 */
package org.mule.client;

import java.util.Map;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointCache;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.transport.ReceiveException;
import org.mule.endpoint.SimpleEndpointCache;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.management.stats.FlowConstructStatistics;

public class DefaultLocalMuleClient
implements LocalMuleClient {
    protected final MuleContext muleContext;
    private final EndpointCache endpointCache;

    public DefaultLocalMuleClient(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.endpointCache = new SimpleEndpointCache(muleContext);
    }

    @Override
    public MuleMessage process(OutboundEndpoint endpoint, Object payload, Map<String, Object> messageProperties) throws MuleException {
        return this.process(endpoint, new DefaultMuleMessage(payload, messageProperties, this.muleContext));
    }

    @Override
    public MuleMessage process(OutboundEndpoint endpoint, MuleMessage message) throws MuleException {
        return this.returnMessage(endpoint.process(this.createMuleEvent(message, endpoint)));
    }

    @Override
    public MuleMessage request(InboundEndpoint endpoint, long timeout) throws MuleException {
        try {
            return endpoint.request(timeout);
        }
        catch (Exception e) {
            throw new ReceiveException(endpoint, timeout, e);
        }
    }

    @Override
    public void dispatch(String url, Object payload, Map<String, Object> messageProperties) throws MuleException {
        this.dispatch(url, new DefaultMuleMessage(payload, messageProperties, this.muleContext));
    }

    @Override
    public MuleMessage send(String url, Object payload, Map<String, Object> messageProperties) throws MuleException {
        return this.send(url, new DefaultMuleMessage(payload, messageProperties, this.muleContext));
    }

    @Override
    public MuleMessage send(String url, MuleMessage message) throws MuleException {
        OutboundEndpoint endpoint = this.endpointCache.getOutboundEndpoint(url, MessageExchangePattern.REQUEST_RESPONSE, null);
        return this.returnMessage(endpoint.process(this.createMuleEvent(message, endpoint)));
    }

    @Override
    public MuleMessage send(String url, Object payload, Map<String, Object> messageProperties, long timeout) throws MuleException {
        return this.send(url, new DefaultMuleMessage(payload, messageProperties, this.muleContext), timeout);
    }

    @Override
    public MuleMessage send(String url, MuleMessage message, long timeout) throws MuleException {
        OutboundEndpoint endpoint = this.endpointCache.getOutboundEndpoint(url, MessageExchangePattern.REQUEST_RESPONSE, timeout);
        return this.returnMessage(endpoint.process(this.createMuleEvent(message, endpoint)));
    }

    @Override
    public void dispatch(String url, MuleMessage message) throws MuleException {
        OutboundEndpoint endpoint = this.endpointCache.getOutboundEndpoint(url, MessageExchangePattern.ONE_WAY, null);
        endpoint.process(this.createMuleEvent(message, endpoint));
    }

    @Override
    public MuleMessage request(String url, long timeout) throws MuleException {
        InboundEndpoint endpoint = this.endpointCache.getInboundEndpoint(url, MessageExchangePattern.ONE_WAY);
        try {
            return endpoint.request(timeout);
        }
        catch (Exception e) {
            throw new ReceiveException(endpoint, timeout, e);
        }
    }

    @Override
    public MuleMessage process(String uri, MessageExchangePattern mep, Object payload, Map<String, Object> messageProperties) throws MuleException {
        return this.process(uri, mep, new DefaultMuleMessage(payload, messageProperties, this.muleContext));
    }

    @Override
    public MuleMessage process(String uri, MessageExchangePattern mep, MuleMessage message) throws MuleException {
        OutboundEndpoint endpoint = this.endpointCache.getOutboundEndpoint(uri, mep, null);
        return this.returnMessage(endpoint.process(this.createMuleEvent(message, endpoint)));
    }

    protected MuleEvent createMuleEvent(MuleMessage message, OutboundEndpoint endpoint) throws EndpointException {
        return new DefaultMuleEvent(message, endpoint.getExchangePattern(), (FlowConstruct)new MuleClientFlowConstruct(this.muleContext));
    }

    protected MuleMessage returnMessage(MuleEvent event) {
        if (event != null && !VoidMuleEvent.getInstance().equals(event)) {
            return event.getMessage();
        }
        return null;
    }

    public static class MuleClientFlowConstruct
    implements FlowConstruct {
        MuleContext muleContext;

        public MuleClientFlowConstruct(MuleContext muleContext) {
            this.muleContext = muleContext;
        }

        @Override
        public String getName() {
            return "MuleClient";
        }

        @Override
        public MessagingExceptionHandler getExceptionListener() {
            return new DefaultMessagingExceptionStrategy(this.muleContext);
        }

        @Override
        public LifecycleState getLifecycleState() {
            return null;
        }

        @Override
        public FlowConstructStatistics getStatistics() {
            return null;
        }

        @Override
        public MuleContext getMuleContext() {
            return this.muleContext;
        }

        @Override
        public MessageInfoMapping getMessageInfoMapping() {
            return null;
        }

        public MessageProcessorChain getMessageProcessorChain() {
            return null;
        }
    }
}

