/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.CollectionUtils;

public class FilteringOutboundRouterTestCase
extends AbstractMuleContextTestCase {
    public FilteringOutboundRouterTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testFilteringOutboundRouterAsync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getFlowConstruct", (Object)FilteringOutboundRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = FilteringOutboundRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?exchangePattern=request-response");
        Assert.assertNotNull((Object)endpoint1);
        Mock mockEndpoint = RouterTestUtils.getMockEndpoint(endpoint1);
        FilteringOutboundRouter router = new FilteringOutboundRouter();
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add((OutboundEndpoint)mockEndpoint.proxy());
        router.setRoutes(endpoints);
        Assert.assertTrue((boolean)router.isUseTemplates());
        Assert.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        mockEndpoint.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)session.proxy(), muleContext));
        mockEndpoint.verify();
        message = new DefaultMuleMessage((Object)new Exception("test event"), muleContext);
        Assert.assertTrue((!router.isMatch((MuleMessage)message) ? 1 : 0) != 0);
        router.setTransformers(CollectionUtils.singletonList((Object)new AbstractTransformer(){

            public Object doTransform(Object src, String encoding) throws TransformerException {
                return ((Exception)src).getMessage();
            }
        }));
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
    }

    @Test
    public void testFilteringOutboundRouterSync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getFlowConstruct", (Object)FilteringOutboundRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = FilteringOutboundRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?exchangePattern=request-response");
        Assert.assertNotNull((Object)endpoint1);
        Mock mockEndpoint = RouterTestUtils.getMockEndpoint(endpoint1);
        FilteringOutboundRouter router = new FilteringOutboundRouter();
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add((OutboundEndpoint)mockEndpoint.proxy());
        router.setRoutes(new ArrayList(endpoints));
        Assert.assertTrue((boolean)router.isUseTemplates());
        Assert.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        mockEndpoint.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)session.proxy(), muleContext));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)message, (Object)result.getMessage());
        session.verify();
    }

    @Test
    public void testFilteringOutboundRouterWithTemplates() throws Exception {
        OutboundEndpoint endpoint1 = FilteringOutboundRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://foo?[barValue]");
        Assert.assertNotNull((Object)endpoint1);
        FilteringOutboundRouter router = new FilteringOutboundRouter();
        router.setMuleContext(muleContext);
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        router.setRoutes(new ArrayList(endpoints));
        Assert.assertTrue((boolean)router.isUseTemplates());
        Assert.assertEquals((Object)filter, (Object)router.getFilter());
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("barValue", "bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", m, muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        OutboundEndpoint ep = (OutboundEndpoint)router.getRoute(0, (MuleEvent)event);
        Assert.assertNotSame((Object)endpoint1, (Object)ep);
        Assert.assertEquals((Object)"test://foo?bar", (Object)ep.getEndpointURI().toString());
    }
}

