/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.junit.Assert;
import org.junit.Test;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class WildcardFilterTestCase
extends AbstractMuleTestCase {
    @Test
    public void testWildcardFilterNoPattern() {
        WildcardFilter filter = new WildcardFilter();
        Assert.assertFalse((boolean)filter.accept((Object)"No tengo dinero"));
        filter.setPattern("* brown fox");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern(null);
        Assert.assertFalse((boolean)filter.accept((Object)"oh-oh"));
    }

    @Test
    public void testWildcardFilterPostfix() {
        WildcardFilter filter = new WildcardFilter("The quick *");
        Assert.assertNotNull((Object)filter.getPattern());
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)"The quick *"));
        Assert.assertTrue((!filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        Assert.assertTrue((!filter.accept((Object)"he quick brown fox") ? 1 : 0) != 0);
    }

    @Test
    public void testWildcardFilterPrefix() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("* brown fox");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)"* brown fox"));
        Assert.assertTrue((!filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        Assert.assertTrue((!filter.accept((Object)"The quick brown fo") ? 1 : 0) != 0);
    }

    @Test
    public void testWildcardFilterExactMatch() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("fox");
        Assert.assertTrue((boolean)filter.accept((Object)"fox"));
        filter.setPattern("");
        Assert.assertTrue((boolean)filter.accept((Object)""));
    }

    @Test
    public void testWildcardFilterPrePost() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("* brown *");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)"* brown fox"));
        Assert.assertTrue((!filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fo"));
        filter.setPattern("**");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern("*w*");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern("*");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern("*.*");
        Assert.assertTrue((boolean)filter.accept((Object)"test.xml"));
        filter.setPattern("*.txt");
        Assert.assertTrue((boolean)filter.accept((Object)"test.txt"));
    }

    @Test
    public void testWildcardFilterMultiplePatterns() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("* brown*, The*");
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)" brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)"The quickbrown fox"));
        filter.setPattern("* if, The*");
        Assert.assertTrue((!filter.accept((Object)"What The!") ? 1 : 0) != 0);
        Assert.assertTrue((!filter.accept((Object)"simplify") ? 1 : 0) != 0);
    }

    @Test
    public void testWildcardFilterCasesensitive() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("* brown fox");
        Assert.assertFalse((boolean)filter.accept((Object)"The quick Brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)"* brown fox"));
        filter.setCaseSensitive(false);
        Assert.assertTrue((boolean)filter.accept((Object)"The quick Brown fox"));
    }

    @Test
    public void testClassAndSubclass() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("java.lang.Throwable+");
        Assert.assertTrue((boolean)filter.accept((Object)new Exception()));
        Assert.assertTrue((boolean)filter.accept((Object)new Throwable()));
        Assert.assertFalse((boolean)filter.accept(new Object()));
        filter.setPattern("java.lang.Throwable");
        Assert.assertFalse((boolean)filter.accept((Object)new Exception()));
        Assert.assertTrue((boolean)filter.accept((Object)new Throwable()));
        Assert.assertFalse((boolean)filter.accept(new Object()));
    }

    @Test
    public void testClassAndSubclassUsingString() {
        WildcardFilter filter = new WildcardFilter();
        filter.setPattern("java.lang.Throwable+");
        Assert.assertTrue((boolean)filter.accept((Object)new Exception().getClass().getName()));
        Assert.assertTrue((boolean)filter.accept((Object)new Throwable().getClass().getName()));
        Assert.assertFalse((boolean)filter.accept((Object)new Object().getClass().getName()));
        filter.setPattern("java.lang.Throwable");
        Assert.assertFalse((boolean)filter.accept((Object)new Exception().getClass().getName()));
        Assert.assertTrue((boolean)filter.accept((Object)new Throwable().getClass().getName()));
        Assert.assertFalse((boolean)filter.accept((Object)new Object().getClass().getName()));
    }
}

