/*
 * Decompiled with CFR 0.152.
 */
package org.mule.message;

import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.MessagePropertiesContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MessagePropertiesContextTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testPropertiesCase() throws Exception {
        MessagePropertiesContext mpc = new MessagePropertiesContext();
        mpc.setProperty("FOO", (Object)"BAR", PropertyScope.OUTBOUND);
        mpc.setProperty("ABC", (Object)"abc", PropertyScope.OUTBOUND);
        mpc.setProperty("DOO", (Object)"DAR", PropertyScope.INVOCATION);
        this.doTest(mpc);
    }

    @Test
    public void testSessionScope() throws Exception {
        MuleEvent e = MessagePropertiesContextTestCase.getTestEvent("testing");
        e.getSession().setProperty("SESSION_PROP", (Serializable)((Object)"Value1"));
        MuleMessage message = e.getMessage();
        Assert.assertEquals((Object)"Value1", (Object)message.getProperty("SESSION_PROP", PropertyScope.SESSION));
        Assert.assertEquals((Object)"Value1", (Object)message.getProperty("SESSION_prop", PropertyScope.SESSION));
        Assert.assertNull((Object)message.getProperty("SESSION_X", PropertyScope.SESSION));
    }

    @Test
    public void testPropertyScopeOrder() throws Exception {
        MuleEvent e = MessagePropertiesContextTestCase.getTestEvent("testing");
        e.getSession().setProperty("Prop", (Serializable)((Object)"session"));
        MuleMessage message = e.getMessage();
        message.setProperty("Prop", (Object)"invocation", PropertyScope.INVOCATION);
        message.setProperty("Prop", (Object)"outbound", PropertyScope.OUTBOUND);
        Assert.assertEquals((Object)"outbound", (Object)message.getProperty("Prop", PropertyScope.OUTBOUND));
        message.removeProperty("Prop", PropertyScope.OUTBOUND);
        Assert.assertEquals((Object)"invocation", (Object)message.getProperty("Prop", PropertyScope.INVOCATION));
        message.removeProperty("Prop", PropertyScope.INVOCATION);
        Assert.assertEquals((Object)"session", (Object)message.getProperty("Prop", PropertyScope.SESSION));
        Assert.assertNull((Object)message.getProperty("Prop", PropertyScope.INBOUND));
        Assert.assertNull((Object)message.getProperty("Prop", PropertyScope.INVOCATION));
        Assert.assertNull((Object)message.getProperty("Prop", PropertyScope.OUTBOUND));
    }

    @Test
    public void testPropertiesCaseAfterSerialization() throws Exception {
        MessagePropertiesContext mpc = new MessagePropertiesContext();
        mpc.setProperty("FOO", (Object)"BAR", PropertyScope.OUTBOUND);
        mpc.setProperty("ABC", (Object)"abc", PropertyScope.OUTBOUND);
        mpc.setProperty("DOO", (Object)"DAR", PropertyScope.INVOCATION);
        this.doTest(mpc);
        byte[] bytes = SerializationUtils.serialize((Serializable)mpc);
        mpc = (MessagePropertiesContext)SerializationUtils.deserialize((byte[])bytes);
        this.doTest(mpc);
    }

    protected void doTest(MessagePropertiesContext mpc) {
        Assert.assertEquals((Object)"BAR", (Object)mpc.getProperty("foo", PropertyScope.OUTBOUND));
        Assert.assertEquals((Object)"DAR", (Object)mpc.getProperty("doo", PropertyScope.INVOCATION));
        Assert.assertEquals((Object)"abc", (Object)mpc.getProperty("abc", PropertyScope.OUTBOUND));
        Assert.assertEquals((Object)"BAR", (Object)mpc.getProperty("foO", PropertyScope.OUTBOUND));
        Assert.assertEquals((Object)"DAR", (Object)mpc.getProperty("doO", PropertyScope.INVOCATION));
        Assert.assertNull((Object)mpc.getProperty("doo", PropertyScope.INBOUND));
        Assert.assertNull((Object)mpc.getProperty("doo", PropertyScope.OUTBOUND));
        Assert.assertNull((Object)mpc.getProperty("doo", PropertyScope.SESSION));
        Set keys = mpc.getPropertyNames();
        Assert.assertEquals((long)3L, (long)keys.size());
        for (String key : keys) {
            Assert.assertTrue((key.equals("FOO") || key.equals("DOO") || key.equals("ABC") ? 1 : 0) != 0);
            Assert.assertFalse((key.equals("foo") || key.equals("doo") || key.equals("abc") ? 1 : 0) != 0);
        }
    }
}

