/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.config.i18n.CoreMessages;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class MessagingExceptionTestCase
extends AbstractMuleTestCase {
    @Mock
    private MuleEvent mockEvent;

    @Test
    public void testGetCauseExceptionWithoutCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent);
        Assert.assertThat((Object)((Object)((MessagingException)((Object)exception.getCauseException()))), (Matcher)Is.is((Object)((Object)exception)));
    }

    @Test
    public void testGetCauseExceptionWithMuleCause() {
        DefaultMuleException causeException = new DefaultMuleException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((DefaultMuleException)exception.getCauseException()), (Matcher)Is.is((Object)causeException));
    }

    @Test
    public void testGetCauseExceptionWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((DefaultMuleException)exception.getCauseException()), (Matcher)Is.is((Object)causeCauseException));
    }

    @Test
    public void testGetCauseExceptionWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((IOException)exception.getCauseException()), (Matcher)Is.is((Object)causeException));
    }

    @Test
    public void testGetCauseExceptionWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)((ConnectException)exception.getCauseException()), (Matcher)Is.is((Object)causeCauseException));
    }

    @Test
    public void testCausedByWithNullCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent);
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(Exception.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(DefaultMuleException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCausedByWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(DefaultMuleException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testCausedByWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(Exception.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(NullPointerException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCausedByWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedBy(NullPointerException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedBy(SocketException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(IOException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedBy(MessagingException.class), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testCausedExactlyByWithNullCause() {
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent);
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(Exception.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(DefaultMuleException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCausedExactlyByWithMuleCauseWithMuleCause() {
        DefaultMuleException causeCauseException = new DefaultMuleException("");
        DefaultMuleException causeException = new DefaultMuleException((Throwable)causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(DefaultMuleException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testCausedExactlyByWithNonMuleCause() {
        IOException causeException = new IOException("");
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(Exception.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(NullPointerException.class), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCausedExactlyByWithNonMuleCauseWithNonMuleCause() {
        ConnectException causeCauseException = new ConnectException();
        IOException causeException = new IOException(causeCauseException);
        MessagingException exception = new MessagingException(CoreMessages.createStaticMessage((String)""), this.mockEvent, (Throwable)causeException);
        Assert.assertThat((Object)exception.causedExactlyBy(ConnectException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(SocketException.class), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)exception.causedExactlyBy(IOException.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)exception.causedExactlyBy(MessagingException.class), (Matcher)Is.is((Object)true));
    }
}

