/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMessageCollection;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.GrapeFruit;
import org.mule.tck.testmodels.fruit.Orange;

public class DefaultMessageCollectionTestCase
extends AbstractMuleTestCase {
    Apple apple = new Apple();
    Banana banana = new Banana();
    GrapeFruit grapeFruit = new GrapeFruit();
    Orange orange = new Orange();
    MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);

    @Test
    public void addMuleMessage() {
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)this.apple, this.muleContext);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)this.banana, this.muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)this.orange, this.muleContext);
        DefaultMessageCollection messageCollection = new DefaultMessageCollection(this.muleContext);
        messageCollection.addMessage((MuleMessage)message1);
        messageCollection.addMessage((MuleMessage)message2);
        messageCollection.addMessage((MuleMessage)message3);
        Assert.assertEquals((long)3L, (long)messageCollection.getMessageList().size());
        Assert.assertSame((Object)message1, (Object)messageCollection.getMessage(0));
        Assert.assertSame((Object)message2, (Object)messageCollection.getMessage(1));
        Assert.assertSame((Object)message3, (Object)messageCollection.getMessage(2));
        Assert.assertEquals((long)3L, (long)messageCollection.getPayloadList().size());
        Assert.assertTrue((boolean)(messageCollection.getPayload() instanceof List));
        Assert.assertSame((Object)this.apple, ((List)messageCollection.getPayload()).get(0));
        Assert.assertSame((Object)this.banana, ((List)messageCollection.getPayload()).get(1));
        Assert.assertSame((Object)this.orange, ((List)messageCollection.getPayload()).get(2));
    }

    @Test
    public void addMuleMessageCollection() {
        MuleMessageCollection messageCollection1 = (MuleMessageCollection)Mockito.mock(MuleMessageCollection.class);
        MuleMessageCollection messageCollection2 = (MuleMessageCollection)Mockito.mock(MuleMessageCollection.class);
        Mockito.when((Object)messageCollection1.getPayload()).thenReturn((Object)new Fruit[]{this.apple, this.banana});
        Mockito.when((Object)messageCollection2.getPayload()).thenReturn((Object)new Fruit[]{this.grapeFruit, this.orange});
        DefaultMessageCollection messageCollectionUnderTest = new DefaultMessageCollection(this.muleContext);
        messageCollectionUnderTest.addMessage((MuleMessage)messageCollection1);
        messageCollectionUnderTest.addMessage((MuleMessage)messageCollection2);
        Assert.assertEquals((long)2L, (long)messageCollectionUnderTest.getMessageList().size());
        Assert.assertSame((Object)messageCollection1, (Object)messageCollectionUnderTest.getMessage(0));
        Assert.assertSame((Object)messageCollection2, (Object)messageCollectionUnderTest.getMessage(1));
        Assert.assertEquals((long)2L, (long)messageCollectionUnderTest.getPayloadList().size());
        Assert.assertTrue((boolean)(messageCollectionUnderTest.getPayload() instanceof List));
        Assert.assertSame((Object)this.apple, (Object)((Fruit[])((List)messageCollectionUnderTest.getPayload()).get(0))[0]);
        Assert.assertSame((Object)this.banana, (Object)((Fruit[])((List)messageCollectionUnderTest.getPayload()).get(0))[1]);
        Assert.assertSame((Object)this.grapeFruit, (Object)((Fruit[])((List)messageCollectionUnderTest.getPayload()).get(1))[0]);
        Assert.assertSame((Object)this.orange, (Object)((Fruit[])((List)messageCollectionUnderTest.getPayload()).get(1))[1]);
    }

    @Test
    public void addMuleMessageAndMuleMessageCollection() {
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)this.grapeFruit, this.muleContext);
        DefaultMuleMessage message4 = new DefaultMuleMessage((Object)this.orange, this.muleContext);
        MuleMessageCollection messageCollection1 = (MuleMessageCollection)Mockito.mock(MuleMessageCollection.class);
        Mockito.when((Object)messageCollection1.getPayload()).thenReturn((Object)new Fruit[]{this.apple, this.banana});
        DefaultMessageCollection messageCollectionUnderTest = new DefaultMessageCollection(this.muleContext);
        messageCollectionUnderTest.addMessage((MuleMessage)messageCollection1);
        messageCollectionUnderTest.addMessage((MuleMessage)message3);
        messageCollectionUnderTest.addMessage((MuleMessage)message4);
        Assert.assertEquals((long)3L, (long)messageCollectionUnderTest.getMessageList().size());
        Assert.assertSame((Object)messageCollection1, (Object)messageCollectionUnderTest.getMessage(0));
        Assert.assertSame((Object)message3, (Object)messageCollectionUnderTest.getMessage(1));
        Assert.assertSame((Object)message4, (Object)messageCollectionUnderTest.getMessage(2));
        Assert.assertEquals((long)3L, (long)messageCollectionUnderTest.getPayloadList().size());
        Assert.assertTrue((boolean)(messageCollectionUnderTest.getPayload() instanceof List));
        Assert.assertSame((Object)this.apple, (Object)((Fruit[])((List)messageCollectionUnderTest.getPayload()).get(0))[0]);
        Assert.assertSame((Object)this.banana, (Object)((Fruit[])((List)messageCollectionUnderTest.getPayload()).get(0))[1]);
        Assert.assertSame((Object)this.grapeFruit, ((List)messageCollectionUnderTest.getPayload()).get(1));
        Assert.assertSame((Object)this.orange, ((List)messageCollectionUnderTest.getPayload()).get(2));
    }
}

