/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.store.AbstractMonitoredObjectStore;

public class InMemoryObjectStore<T extends Serializable>
extends AbstractMonitoredObjectStore<T> {
    protected ConcurrentSkipListMap<Long, StoredObject<T>> store = new ConcurrentSkipListMap();

    @Override
    public boolean isPersistent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Serializable key) throws ObjectStoreException {
        if (key == null) {
            throw new ObjectStoreException(CoreMessages.objectIsNull("id"));
        }
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            return this.store.values().contains(new StoredObject<Object>(key, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Serializable id, T value) throws ObjectStoreException {
        if (id == null) {
            throw new ObjectStoreException(CoreMessages.objectIsNull("id"));
        }
        StoredObject<T> obj = new StoredObject<T>(id, value);
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            if (this.store.values().contains(obj)) {
                throw new ObjectAlreadyExistsException();
            }
            boolean written = false;
            while (!written) {
                Long key = System.nanoTime();
                written = this.store.put(key, obj) == null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T retrieve(Serializable key) throws ObjectStoreException {
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Map.Entry<?, ?> entry = this.findEntry(key);
            if (entry != null) {
                StoredObject object = (StoredObject)entry.getValue();
                return (T)((Serializable)object.getItem());
            }
        }
        throw new ObjectDoesNotExistException(CoreMessages.objectNotFound(key));
    }

    private Map.Entry<?, ?> findEntry(Serializable key) {
        for (Map.Entry<Long, StoredObject<T>> entry : this.store.entrySet()) {
            StoredObject<T> object = entry.getValue();
            if (!object.getId().equals(key)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(Serializable key) throws ObjectStoreException {
        ConcurrentSkipListMap<Long, StoredObject<T>> concurrentSkipListMap = this.store;
        synchronized (concurrentSkipListMap) {
            Map.Entry<?, ?> entry = this.findEntry(key);
            if (entry != null) {
                StoredObject<T> removedObject = this.store.remove(entry.getKey());
                return (T)((Serializable)removedObject.getItem());
            }
        }
        throw new ObjectDoesNotExistException(CoreMessages.objectNotFound(key));
    }

    @Override
    public void expire() {
        int currentSize = this.store.size();
        currentSize = this.trimToMaxSize(currentSize);
        if (this.entryTTL > 0 && currentSize != 0) {
            Long oldestKey;
            long oldestKeyValue;
            Map.Entry<Long, StoredObject<T>> oldestEntry;
            long now = System.nanoTime();
            int expiredEntries = 0;
            while ((oldestEntry = this.store.firstEntry()) != null && TimeUnit.NANOSECONDS.toMillis(now - (oldestKeyValue = (oldestKey = oldestEntry.getKey()).longValue())) >= (long)this.entryTTL) {
                this.store.remove(oldestKey);
                ++expiredEntries;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Expired " + expiredEntries + " old entries"));
            }
        }
    }

    private int trimToMaxSize(int currentSize) {
        if (this.maxEntries < 0) {
            return currentSize;
        }
        int excess = currentSize - this.maxEntries;
        if (excess > 0) {
            while (currentSize > this.maxEntries) {
                this.store.pollFirstEntry();
                --currentSize;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Expired " + excess + " excess entries"));
            }
        }
        return currentSize;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.store;
    }

    protected static class StoredObject<T> {
        private Serializable id;
        private T item;

        public StoredObject(Serializable id, T item) {
            this.id = id;
            this.item = item;
        }

        public Serializable getId() {
            return this.id;
        }

        public T getItem() {
            return this.item;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StoredObject that = (StoredObject)o;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("StoredObject");
            sb.append("{id='").append(this.id).append('\'');
            sb.append(", item=").append(this.item);
            sb.append('}');
            return sb.toString();
        }
    }
}

