/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.NameableObject;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.BlockingServerEvent;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.processor.MessageProcessor;
import org.mule.transport.NullPayload;
import org.mule.util.ObjectUtils;

public class MessageProcessorNotification
extends ServerNotification
implements BlockingServerEvent {
    private static final long serialVersionUID = 1L;
    public static final int MESSAGE_PROCESSOR_PRE_INVOKE = 1601;
    public static final int MESSAGE_PROCESSOR_POST_INVOKE = 1602;
    private final transient MessageProcessor processor;
    private static ThreadLocal<String> lastRootMessageId;
    private MessagingException exceptionThrown;

    public MessageProcessorNotification(FlowConstruct flowConstruct, MuleEvent event, MessageProcessor processor, MessagingException exceptionThrown, int action) {
        super(MessageProcessorNotification.produceEvent(event, flowConstruct), action, flowConstruct != null ? flowConstruct.getName() : null);
        this.exceptionThrown = exceptionThrown;
        this.processor = processor;
    }

    @Override
    public MuleEvent getSource() {
        if (this.source instanceof String) {
            return null;
        }
        return (MuleEvent)super.getSource();
    }

    public MessageProcessor getProcessor() {
        return this.processor;
    }

    protected String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        String name = obj instanceof NameableObject ? String.format("%s '%s'", obj.getClass().getName(), ((NameableObject)obj).getName()) : ObjectUtils.identityToString((Object)obj);
        return name;
    }

    private static MuleEvent produceEvent(MuleEvent sourceEvent, FlowConstruct flowConstruct) {
        String rootId = lastRootMessageId.get();
        if (sourceEvent != null && !VoidMuleEvent.getInstance().equals(sourceEvent)) {
            lastRootMessageId.set(sourceEvent.getMessage().getMessageRootId());
            return sourceEvent;
        }
        if (rootId != null && flowConstruct != null) {
            DefaultMuleMessage msg = new DefaultMuleMessage(NullPayload.getInstance(), flowConstruct.getMuleContext());
            msg.setMessageRootId(rootId);
            return new DefaultMuleEvent((MuleMessage)msg, MessageExchangePattern.REQUEST_RESPONSE, flowConstruct);
        }
        return null;
    }

    public MessagingException getExceptionThrown() {
        return this.exceptionThrown;
    }

    static {
        MessageProcessorNotification.registerAction("message processor pre invoke", 1601);
        MessageProcessorNotification.registerAction("message processor post invoke", 1602);
        lastRootMessageId = new ThreadLocal();
    }
}

