/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.UUID;
import org.mule.util.concurrent.DaemonThreadFactory;
import org.mule.util.store.DeserializationPostInitialisable;

public class MonitoredObjectStoreWrapper<T extends Serializable>
implements ListableObjectStore<T>,
Runnable,
MuleContextAware,
Initialisable,
Disposable {
    protected MuleContext context;
    protected ScheduledThreadPoolExecutor scheduler;
    ListableObjectStore<StoredObject<T>> baseStore;
    private static Log logger = LogFactory.getLog(MonitoredObjectStoreWrapper.class);
    protected int maxEntries = 4000;
    protected int entryTTL = -1;
    protected int expirationInterval = 1000;
    protected String name = null;

    public MonitoredObjectStoreWrapper(ListableObjectStore<StoredObject<T>> baseStore) {
        this.baseStore = baseStore;
    }

    public MonitoredObjectStoreWrapper(ListableObjectStore<StoredObject<T>> baseStore, int maxEntries, int entryTTL, int expirationInterval) {
        this.baseStore = baseStore;
        this.maxEntries = maxEntries;
        this.entryTTL = entryTTL;
        this.expirationInterval = expirationInterval;
    }

    @Override
    public boolean contains(Serializable key) throws ObjectStoreException {
        return this.getStore().contains(key);
    }

    @Override
    public void store(Serializable key, T value) throws ObjectStoreException {
        Long time = System.nanoTime();
        this.getStore().store(key, new StoredObject<T>(value, time, key));
    }

    @Override
    public T retrieve(Serializable key) throws ObjectStoreException {
        return (T)((Serializable)((StoredObject)this.getStore().retrieve(key)).getItem());
    }

    @Override
    public T remove(Serializable key) throws ObjectStoreException {
        StoredObject object = (StoredObject)this.getStore().remove(key);
        if (object == null) {
            return null;
        }
        return (T)((Serializable)object.getItem());
    }

    @Override
    public boolean isPersistent() {
        return this.getStore().isPersistent();
    }

    @Override
    public void open() throws ObjectStoreException {
        this.getStore().open();
    }

    @Override
    public void close() throws ObjectStoreException {
        this.getStore().close();
    }

    @Override
    public List<Serializable> allKeys() throws ObjectStoreException {
        return this.getStore().allKeys();
    }

    private ListableObjectStore<StoredObject<T>> getStore() {
        if (this.baseStore == null) {
            this.baseStore = (ListableObjectStore)this.context.getRegistry().lookupObject("_defaultPersistentQueueStore");
        }
        return this.baseStore;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    @Override
    public void run() {
        if (this.context.isPrimaryPollingInstance()) {
            this.expire();
        }
    }

    public void expire() {
        try {
            long now = System.nanoTime();
            List<Serializable> keys = this.allKeys();
            int excess = this.allKeys().size() - this.maxEntries;
            if (this.maxEntries > 0 && excess > 0) {
                PriorityQueue<StoredObject> q = new PriorityQueue<StoredObject>(excess, new Comparator<StoredObject<T>>(){

                    @Override
                    public int compare(StoredObject<T> paramT1, StoredObject<T> paramT2) {
                        return paramT2.timestamp.compareTo(paramT1.timestamp);
                    }
                });
                long youngest = Long.MAX_VALUE;
                for (Serializable key : keys) {
                    StoredObject obj = (StoredObject)this.getStore().retrieve(key);
                    if (this.entryTTL > 0 && TimeUnit.NANOSECONDS.toMillis(now - obj.getTimestamp()) >= (long)this.entryTTL) {
                        this.remove(key);
                        if (--excess <= 0 || q.size() <= excess) continue;
                        q.poll();
                        youngest = ((StoredObject)q.peek()).timestamp;
                        continue;
                    }
                    if (excess > 0 && (q.size() < excess || obj.timestamp < youngest)) {
                        q.offer(obj);
                        youngest = ((StoredObject)q.peek()).timestamp;
                    }
                    if (excess <= 0 || q.size() <= excess) continue;
                    q.poll();
                    youngest = ((StoredObject)q.peek()).timestamp;
                }
                for (int i = 0; i < excess; ++i) {
                    Serializable key;
                    key = ((StoredObject)q.poll()).key;
                    this.remove(key);
                }
            } else if (this.entryTTL > 0) {
                for (Serializable key : keys) {
                    StoredObject obj = (StoredObject)this.getStore().retrieve(key);
                    if (TimeUnit.NANOSECONDS.toMillis(now - obj.getTimestamp()) < (long)this.entryTTL) continue;
                    this.remove(key);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Running expirty on " + this.baseStore + " threw " + e + ":" + e.getMessage()));
        }
    }

    @Override
    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.name == null) {
            this.name = UUID.getUUID();
        }
        if (this.expirationInterval <= 0) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue("expirationInterval", new Integer(this.expirationInterval)).toString());
        }
        if (this.scheduler == null) {
            this.scheduler = new ScheduledThreadPoolExecutor(1);
            this.scheduler.setThreadFactory(new DaemonThreadFactory(this.name + "-Monitor", this.getClass().getClassLoader()));
            this.scheduler.scheduleWithFixedDelay(this, 0L, this.expirationInterval, TimeUnit.MILLISECONDS);
        }
    }

    protected static class StoredObject<T>
    implements Serializable,
    DeserializationPostInitialisable {
        private static final long serialVersionUID = 8656763235928199259L;
        private final T item;
        private final Long timestamp;
        private final Serializable key;

        public StoredObject(T item, Long timestamp, Serializable key) {
            this.item = item;
            this.timestamp = timestamp;
            this.key = key;
        }

        public T getItem() {
            return this.item;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public Serializable getKey() {
            return this.key;
        }

        private void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
            if (this.item instanceof DeserializationPostInitialisable) {
                try {
                    DeserializationPostInitialisable.Implementation.init(this.item, muleContext);
                }
                catch (Exception e) {
                    throw new DefaultMuleException(e);
                }
            }
        }
    }
}

