/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;

public class ManagedObjectStore<T extends Serializable>
implements ListableObjectStore<T>,
MuleContextAware {
    String storeName;
    boolean isPersistent;
    ListableObjectStore<T> store;
    MuleContext context;
    int maxEntries = 0;
    int entryTTL;
    int expirationInterval;

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    @Override
    public boolean isPersistent() {
        return this.isPersistent;
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public int getEntryTTL() {
        return this.entryTTL;
    }

    public void setEntryTTL(int entryTTL) {
        this.entryTTL = entryTTL;
    }

    public int getExpirationInterval() {
        return this.expirationInterval;
    }

    public void setExpirationInterval(int expirationInterval) {
        this.expirationInterval = expirationInterval;
    }

    @Override
    public boolean contains(Serializable key) throws ObjectStoreException {
        return this.getStore().contains(key);
    }

    @Override
    public void store(Serializable key, T value) throws ObjectStoreException {
        this.getStore().store(key, value);
    }

    @Override
    public T retrieve(Serializable key) throws ObjectStoreException {
        return this.getStore().retrieve(key);
    }

    @Override
    public T remove(Serializable key) throws ObjectStoreException {
        return this.getStore().remove(key);
    }

    @Override
    public void open() throws ObjectStoreException {
        ListableObjectStore<T> store = this.getStore();
        if (store != null) {
            store.open();
        }
    }

    @Override
    public void close() throws ObjectStoreException {
        ListableObjectStore<T> store = this.getStore();
        if (store != null) {
            this.getStore().close();
        }
    }

    @Override
    public List<Serializable> allKeys() throws ObjectStoreException {
        ListableObjectStore<T> store = this.getStore();
        if (store != null) {
            return store.allKeys();
        }
        return new ArrayList<Serializable>();
    }

    private ListableObjectStore<T> getStore() {
        if (this.store == null) {
            ObjectStoreManager objectStoreManager = (ObjectStoreManager)this.context.getRegistry().lookupObject("_muleObjectStoreManager");
            if (objectStoreManager == null) {
                return null;
            }
            this.store = this.maxEntries != 0 ? (ListableObjectStore)objectStoreManager.getObjectStore(this.storeName, this.isPersistent, this.maxEntries, this.entryTTL, this.expirationInterval) : (ListableObjectStore)objectStoreManager.getObjectStore(this.storeName, this.isPersistent);
        }
        return this.store;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }
}

