/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.store.ObjectStoreException;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueInfo;
import org.mule.util.queue.QueueSession;
import org.mule.util.queue.QueueTransactionContext;
import org.mule.util.queue.TransactionalQueueManager;
import org.mule.util.store.DeserializationPostInitialisable;
import org.mule.util.xa.AbstractXAResourceManager;
import org.mule.util.xa.DefaultXASession;

class TransactionalQueueSession
extends DefaultXASession
implements QueueSession {
    private Log logger = LogFactory.getLog(TransactionalQueueSession.class);
    protected TransactionalQueueManager queueManager;

    public TransactionalQueueSession(AbstractXAResourceManager resourceManager, TransactionalQueueManager queueManager) {
        super(resourceManager);
        this.queueManager = queueManager;
    }

    @Override
    public Queue getQueue(String name) {
        QueueInfo queue = this.queueManager.getQueue(name);
        return new QueueImpl(queue);
    }

    protected class QueueImpl
    implements Queue {
        protected QueueInfo queue;

        public QueueImpl(QueueInfo queue) {
            this.queue = queue;
        }

        @Override
        public void put(Serializable item) throws InterruptedException, ObjectStoreException {
            this.offer(item, Long.MAX_VALUE);
        }

        @Override
        public boolean offer(Serializable item, long timeout) throws InterruptedException, ObjectStoreException {
            if (TransactionalQueueSession.this.localContext != null && !this.queue.isQueueTransactional()) {
                return ((QueueTransactionContext)TransactionalQueueSession.this.localContext).offer(this.queue, item, timeout);
            }
            try {
                Serializable id = TransactionalQueueSession.this.queueManager.doStore(this.queue, item);
                try {
                    if (!this.queue.offer(id, 0, timeout)) {
                        TransactionalQueueSession.this.queueManager.doRemove(this.queue, id);
                        return false;
                    }
                    return true;
                }
                catch (InterruptedException e) {
                    TransactionalQueueSession.this.queueManager.doRemove(this.queue, id);
                    throw e;
                }
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Serializable take() throws InterruptedException {
            return this.poll(Long.MAX_VALUE);
        }

        @Override
        public void untake(Serializable item) throws InterruptedException, ObjectStoreException {
            if (TransactionalQueueSession.this.localContext != null && !this.queue.isQueueTransactional()) {
                ((QueueTransactionContext)TransactionalQueueSession.this.localContext).untake(this.queue, item);
            } else {
                Serializable id = TransactionalQueueSession.this.queueManager.doStore(this.queue, item);
                this.queue.untake(id);
            }
        }

        @Override
        public Serializable poll(long timeout) throws InterruptedException {
            try {
                if (TransactionalQueueSession.this.localContext != null && !this.queue.isQueueTransactional()) {
                    Serializable item = ((QueueTransactionContext)TransactionalQueueSession.this.localContext).poll(this.queue, timeout);
                    return this.postProcessIfNeeded(item);
                }
                if (this.queue.canTakeFromStore()) {
                    Serializable item = this.queue.takeNextItemFromStore(timeout);
                    return this.postProcessIfNeeded(item);
                }
                Serializable id = this.queue.poll(timeout);
                if (id != null) {
                    Serializable item = TransactionalQueueSession.this.queueManager.doLoad(this.queue, id);
                    if (item != null) {
                        TransactionalQueueSession.this.queueManager.doRemove(this.queue, id);
                    }
                    return this.postProcessIfNeeded(item);
                }
                return null;
            }
            catch (InterruptedException iex) {
                if (TransactionalQueueSession.this.queueManager.getMuleContext().isStopping()) {
                    throw iex;
                }
                return null;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Serializable peek() throws InterruptedException {
            try {
                if (TransactionalQueueSession.this.localContext != null && !this.queue.isQueueTransactional()) {
                    Serializable item = ((QueueTransactionContext)TransactionalQueueSession.this.localContext).peek(this.queue);
                    return this.postProcessIfNeeded(item);
                }
                Serializable id = this.queue.peek();
                if (id != null) {
                    Serializable item = TransactionalQueueSession.this.queueManager.doLoad(this.queue, id);
                    return this.postProcessIfNeeded(item);
                }
                return null;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int size() {
            if (TransactionalQueueSession.this.localContext != null && !this.queue.isQueueTransactional()) {
                return ((QueueTransactionContext)TransactionalQueueSession.this.localContext).size(this.queue);
            }
            return this.queue.getSize();
        }

        @Override
        public String getName() {
            return this.queue.getName();
        }

        private Serializable postProcessIfNeeded(Serializable item) {
            try {
                if (item instanceof DeserializationPostInitialisable) {
                    DeserializationPostInitialisable.Implementation.init(item, TransactionalQueueSession.this.queueManager.getMuleContext());
                }
                return item;
            }
            catch (Exception e) {
                TransactionalQueueSession.this.logger.warn((Object)"Unable to deserialize message", (Throwable)e);
                return null;
            }
        }
    }
}

