/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;

public class MessagePropertiesTransformer
extends AbstractMessageTransformer {
    private List<String> deleteProperties = null;
    private Map<String, Object> addProperties = null;
    private Map<String, String> renameProperties;
    private String getProperty;
    private boolean overwrite = true;
    private PropertyScope scope = PropertyScope.OUTBOUND;

    public MessagePropertiesTransformer() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    public Object clone() throws CloneNotSupportedException {
        MessagePropertiesTransformer clone = (MessagePropertiesTransformer)super.clone();
        if (this.deleteProperties != null) {
            clone.setDeleteProperties(new ArrayList<String>(this.deleteProperties));
        }
        if (this.addProperties != null) {
            clone.setAddProperties(new HashMap<String, Object>(this.addProperties));
        }
        if (this.renameProperties != null) {
            clone.setRenameProperties(new HashMap<String, String>(this.renameProperties));
        }
        return clone;
    }

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) {
        if (this.deleteProperties != null && this.deleteProperties.size() > 0) {
            this.deleteProperties(message);
        }
        if (this.addProperties != null && this.addProperties.size() > 0) {
            this.addProperties(message);
        }
        if (this.renameProperties != null && this.renameProperties.size() > 0) {
            this.renameProperties(message);
        }
        if (this.getProperty != null) {
            Object prop = message.getProperty(this.getProperty, this.scope);
            message = prop != null ? new DefaultMuleMessage(prop, this.muleContext) : new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext);
        }
        return message;
    }

    protected void deleteProperties(MuleMessage message) {
        HashSet<String> propertyNames = new HashSet<String>(message.getPropertyNames(this.scope));
        for (String expression : this.deleteProperties) {
            for (String key : propertyNames) {
                if (key.matches(expression)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)String.format("Removing property: '%s' from scope: '%s'", key, this.scope.getScopeName()));
                    }
                    message.removeProperty(key, this.scope);
                    continue;
                }
                WildcardFilter filter = new WildcardFilter(expression);
                if (!filter.accept(key)) continue;
                message.removeProperty(key, this.scope);
            }
        }
    }

    protected void addProperties(MuleMessage message) {
        for (Map.Entry<String, Object> entry : this.addProperties.entrySet()) {
            Object value;
            if (entry.getKey() == null) {
                this.logger.error((Object)"Setting Null property keys is not supported, this entry is being ignored");
                continue;
            }
            String key = entry.getKey();
            Object realValue = value = entry.getValue();
            if (this.muleContext.getExpressionManager().isExpression(value.toString())) {
                realValue = this.muleContext.getExpressionManager().evaluate(value.toString(), message);
            }
            if (realValue != null) {
                if (message.getProperty(key, this.scope) != null) {
                    if (this.overwrite) {
                        this.logger.debug((Object)("Overwriting message property " + key));
                        message.setProperty(key, realValue, this.scope);
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)MessageFormat.format("Message already contains the property and overwrite is false, skipping: key={0}, value={1}, scope={2}", key, realValue, this.scope));
                    continue;
                }
                message.setProperty(key, realValue, this.scope);
                continue;
            }
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)MessageFormat.format("Property with key '{0}', not found on message using '{1}'. Since the value was marked optional, nothing was set on the message for this property", key, value));
        }
    }

    protected void renameProperties(MuleMessage message) {
        for (Map.Entry<String, String> entry : this.renameProperties.entrySet()) {
            Object temp;
            if (entry.getKey() == null) {
                this.logger.error((Object)"Setting Null property keys is not supported, this entry is being ignored");
                continue;
            }
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                this.logger.error((Object)"Setting Null property values for renameProperties is not supported, this entry is being ignored");
                continue;
            }
            if (this.muleContext.getExpressionManager().isValidExpression(value) && (temp = this.muleContext.getExpressionManager().evaluate(value, message)) != null) {
                value = temp.toString();
            }
            if (this.logger.isDebugEnabled() && message.getProperty(key, this.scope) == null) {
                this.logger.debug((Object)String.format("renaming message property '%s' to '%s'", key, value));
            }
            this.renameInScope(key, value, this.scope, message);
        }
    }

    protected void renameInScope(String oldKey, String newKey, PropertyScope propertyScope, MuleMessage message) {
        Object propValue = message.getProperty(oldKey, propertyScope);
        message.removeProperty(oldKey, propertyScope);
        message.setProperty(newKey, propValue, propertyScope);
    }

    public List<String> getDeleteProperties() {
        return this.deleteProperties;
    }

    public void setDeleteProperties(List<String> deleteProperties) {
        this.deleteProperties = deleteProperties;
    }

    public void setDeleteProperties(String ... deleteProperties) {
        this.deleteProperties = Arrays.asList(deleteProperties);
    }

    public Map<String, Object> getAddProperties() {
        return this.addProperties;
    }

    public void setAddProperties(Map<String, Object> addProperties) {
        this.addProperties = addProperties;
    }

    public Map<String, String> getRenameProperties() {
        return this.renameProperties;
    }

    public void setRenameProperties(Map<String, String> renameProperties) {
        this.renameProperties = renameProperties;
    }

    public String getGetProperty() {
        return this.getProperty;
    }

    public void setGetProperty(String getProperty) {
        this.getProperty = getProperty;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public PropertyScope getScope() {
        return this.scope;
    }

    public void setScope(PropertyScope scope) {
        this.scope = scope;
    }

    public String getScopeName() {
        return this.scope != null ? this.scope.getScopeName() : null;
    }

    public void setScopeName(String scopeName) {
        this.scope = PropertyScope.get(scopeName);
    }
}

