/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.execution.MessageProcessorExecutionInterceptor;

class MessageProcessorNotificationExecutionInterceptor
implements MessageProcessorExecutionInterceptor {
    private MessageProcessorExecutionInterceptor next;

    MessageProcessorNotificationExecutionInterceptor(MessageProcessorExecutionInterceptor next) {
        this.next = next;
    }

    @Override
    public MuleEvent execute(MessageProcessor messageProcessor, MuleEvent event) throws MessagingException {
        ServerNotificationManager notificationManager = event.getMuleContext().getNotificationManager();
        this.fireNotification(notificationManager, event.getFlowConstruct(), event, messageProcessor, null, 1601);
        MuleEvent result = null;
        MessagingException exceptionThrown = null;
        try {
            result = this.next.execute(messageProcessor, event);
            this.fireNotification(notificationManager, event.getFlowConstruct(), result != null ? result : event, messageProcessor, exceptionThrown, 1602);
        }
        catch (MessagingException e) {
            try {
                exceptionThrown = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.fireNotification(notificationManager, event.getFlowConstruct(), result != null ? result : event, messageProcessor, exceptionThrown, 1602);
                throw throwable;
            }
        }
        return result;
    }

    protected void fireNotification(ServerNotificationManager serverNotificationManager, FlowConstruct flowConstruct, MuleEvent event, MessageProcessor processor, MessagingException exceptionThrown, int action) {
        if (serverNotificationManager != null && serverNotificationManager.isNotificationEnabled(MessageProcessorNotification.class)) {
            serverNotificationManager.fireNotification(new MessageProcessorNotification(flowConstruct, event, processor, exceptionThrown, action));
        }
    }
}

