/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class ServerContext {
    public static String getHost() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static String getIp() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static OperatingSystemContext getOs() throws UnknownHostException {
        return new OperatingSystemContext();
    }

    public static JAVARuntimeContext getJava() {
        return new JAVARuntimeContext();
    }

    public static TimeZone getTimeZone() {
        return Calendar.getInstance().getTimeZone();
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public String getFileSeperator() {
        return System.getProperty("file.separator");
    }

    public String getUser() {
        return System.getProperty("user.name");
    }

    public Map<String, String> getEnv() {
        return System.getenv();
    }

    public static class JAVARuntimeContext {
        public String getVersion() {
            return System.getProperty("java.version");
        }

        public String getVendor() {
            return System.getProperty("java.vendor");
        }

        public Properties getProperties() {
            return System.getProperties();
        }

        public String toString() {
            return this.getVersion() + " (" + this.getVendor() + ")";
        }
    }

    public static class OperatingSystemContext {
        public String getName() {
            return System.getProperty("os.name");
        }

        public String getArch() {
            return System.getProperty("os.arch");
        }

        public String getVersion() {
            return System.getProperty("os.version");
        }

        public String toString() {
            return this.getName() + " (" + this.getVersion() + ", " + this.getArch() + ")";
        }
    }
}

