/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.ReloadControl;

public abstract class MessageFactory {
    public static final ResourceBundle.Control DEFAULT_RELOAD_CONTROL = new ReloadControl.Always();
    private static final int STATIC_ERROR_CODE = -1;
    private static final transient Object[] EMPTY_ARGS = new Object[0];
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ResourceBundle.Control reloadControl = null;

    protected static String getBundlePath(String bundleName) {
        return "META-INF.services.org.mule.i18n." + bundleName + "-messages";
    }

    protected Message createMessage(String bundlePath, int code, Object arg) {
        return this.createMessage(bundlePath, code, new Object[]{arg});
    }

    protected Message createMessage(String bundlePath, int code, Object arg1, Object arg2) {
        return this.createMessage(bundlePath, code, new Object[]{arg1, arg2});
    }

    protected Message createMessage(String bundlePath, int code, Object arg1, Object arg2, Object arg3) {
        return this.createMessage(bundlePath, code, new Object[]{arg1, arg2, arg3});
    }

    protected Message createMessage(String bundlePath, int code, Object ... arguments) {
        String messageString = this.getString(bundlePath, code, arguments);
        return new Message(messageString, code, arguments);
    }

    protected Message createMessage(String bundlePath, int code) {
        String messageString = this.getString(bundlePath, code, null);
        return new Message(messageString, code, EMPTY_ARGS);
    }

    public static Message createStaticMessage(String message) {
        return new Message(message, -1, EMPTY_ARGS);
    }

    protected String getString(String bundlePath, int code) {
        return this.getString(bundlePath, code, null);
    }

    protected String getString(String bundlePath, int code, Object arg) {
        Object[] arguments = new Object[]{arg};
        return this.getString(bundlePath, code, arguments);
    }

    protected String getString(String bundlePath, int code, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return this.getString(bundlePath, code, arguments);
    }

    protected String getString(String bundlePath, int code, Object[] args) {
        ResourceBundle bundle = this.getBundle(bundlePath);
        try {
            String m = bundle.getString(String.valueOf(code));
            if (m == null) {
                this.logger.error((Object)("Failed to find message for id " + code + " in resource bundle " + bundlePath));
                return "";
            }
            return MessageFormat.format(m, args);
        }
        catch (MissingResourceException e) {
            this.logger.error((Object)("Failed to find message for id " + code + " in resource bundle " + bundlePath));
            return "";
        }
    }

    private ResourceBundle getBundle(String bundlePath) {
        ResourceBundle.Control control;
        Locale locale = Locale.getDefault();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Loading resource bundle: " + bundlePath + " for locale " + locale));
        }
        ResourceBundle bundle = (control = this.getReloadControl()) != null ? ResourceBundle.getBundle(bundlePath, locale, this.getClassLoader(), control) : ResourceBundle.getBundle(bundlePath, locale, this.getClassLoader());
        return bundle;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        return ccl == null ? this.getClass().getClassLoader() : ccl;
    }

    protected ResourceBundle.Control getReloadControl() {
        return this.reloadControl;
    }
}

