/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.FatalException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.FileUtils;
import org.mule.util.NumberUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;

public class DefaultMuleConfiguration
implements MuleConfiguration,
MuleContextAware {
    public static final boolean DEFAULT_TRANSFORMATION_RESOLVE_NON_DIRECT = true;
    public static final String[] DEFAULT_STACKTRACE_FILTER = "org.mule.processor.AbstractInterceptingMessageProcessor,org.mule.processor.chain".split(",");
    public static boolean fullStackTraces = false;
    public static boolean verboseExceptions = false;
    public static String[] stackTraceFilter = DEFAULT_STACKTRACE_FILTER;
    private boolean synchronous = false;
    private String systemModelType = "seda";
    private String encoding = "UTF-8";
    private int responseTimeout = 10000;
    private int defaultTransactionTimeout = 30000;
    private int defaultQueueTimeout = 200;
    private int shutdownTimeout = 5000;
    private String workingDirectory = "./.mule";
    private boolean clientMode = false;
    private String id;
    private String clusterId = "";
    private String domainId;
    private boolean cacheMessageAsBytes = true;
    private boolean cacheMessageOriginalPayload = true;
    private boolean enableStreaming = true;
    private boolean autoWrapMessageAwareTransform = true;
    protected transient Log logger = LogFactory.getLog(DefaultMuleConfiguration.class);
    private MuleContext muleContext;
    private boolean containerMode;
    private boolean validateExpressions = true;
    private boolean useExtendedTransformations = true;
    private boolean flowEndingWithOneWayEndpointReturnsNull;
    private Map<String, String> extendedProperties = new HashMap<String, String>();
    private String defaultExceptionStrategyName;

    public DefaultMuleConfiguration() {
        this(false);
    }

    public DefaultMuleConfiguration(boolean containerMode) {
        this.containerMode = containerMode;
        this.applySystemProperties();
        if (this.id == null) {
            this.id = UUID.getUUID();
        }
        if (this.domainId == null) {
            try {
                this.domainId = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.logger.warn((Object)e);
                this.domainId = "org.mule";
            }
        }
        try {
            this.validateEncoding();
            this.validateXML();
        }
        catch (FatalException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.containerMode) {
            String muleHome = System.getProperty("mule.home");
            this.workingDirectory = !this.isStandalone() ? String.format("%s/%s", this.getWorkingDirectory(), this.getId()) : String.format("%s/%s/%s", muleHome.trim(), this.getWorkingDirectory(), this.getId());
        } else if (this.isStandalone()) {
            this.workingDirectory = String.format("%s/%s", this.getWorkingDirectory(), this.getId());
        }
    }

    protected void applySystemProperties() {
        String p = System.getProperty("mule.encoding");
        if (p != null) {
            this.encoding = p;
        } else {
            System.setProperty("mule.encoding", this.encoding);
        }
        p = System.getProperty("mule.endpoints.synchronous");
        if (p != null) {
            this.synchronous = BooleanUtils.toBoolean((String)p);
        }
        if ((p = System.getProperty("mule.systemModelType")) != null) {
            this.systemModelType = p;
        }
        if ((p = System.getProperty("mule.timeout.synchronous")) != null) {
            this.responseTimeout = NumberUtils.toInt(p);
        }
        if ((p = System.getProperty("mule.timeout.transaction")) != null) {
            this.defaultTransactionTimeout = NumberUtils.toInt(p);
        }
        if ((p = System.getProperty("mule.workingDirectory")) != null) {
            this.workingDirectory = p;
        }
        if ((p = System.getProperty("mule.clientMode")) != null) {
            this.clientMode = BooleanUtils.toBoolean((String)p);
        }
        if ((p = System.getProperty("mule.serverId")) != null) {
            this.id = p;
        }
        if ((p = System.getProperty("mule.domainId")) != null) {
            this.domainId = p;
        }
        if ((p = System.getProperty("mule.message.cacheBytes")) != null) {
            this.cacheMessageAsBytes = BooleanUtils.toBoolean((String)p);
        }
        if ((p = System.getProperty("mule.message.cacheOriginal")) != null) {
            this.cacheMessageOriginalPayload = BooleanUtils.toBoolean((String)p);
        }
        if ((p = System.getProperty("mule.streaming.enable")) != null) {
            this.enableStreaming = BooleanUtils.toBoolean((String)p);
        }
        if ((p = System.getProperty("mule.transform.autoWrap")) != null) {
            this.autoWrapMessageAwareTransform = BooleanUtils.toBoolean((String)p);
        }
        if ((p = System.getProperty("mule.stacktrace.full")) != null) {
            fullStackTraces = false;
        }
        if ((p = System.getProperty("mule.stacktrace.filter")) != null) {
            stackTraceFilter = p.split(",");
        }
        verboseExceptions = (p = System.getProperty("mule.verbose.exceptions")) != null ? BooleanUtils.toBoolean((String)p) : this.logger.isDebugEnabled();
        p = System.getProperty("mule.validate.expressions");
        if (p != null) {
            this.validateExpressions = Boolean.valueOf(p);
        }
    }

    protected void validateEncoding() throws FatalException {
        if (!Charset.isSupported(this.encoding)) {
            throw new FatalException(CoreMessages.propertyHasInvalidValue("encoding", this.encoding), (Object)this);
        }
    }

    protected void validateXML() throws FatalException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        if (f == null || f.getClass().getName().indexOf("crimson") != -1) {
            throw new FatalException(CoreMessages.valueIsInvalidFor(f.getClass().getName(), "javax.xml.parsers.SAXParserFactory"), (Object)this);
        }
    }

    public void setDefaultSynchronousEndpoints(boolean synchronous) {
        if (this.verifyContextNotStarted()) {
            this.synchronous = synchronous;
        }
    }

    @Override
    public int getDefaultResponseTimeout() {
        return this.responseTimeout;
    }

    public void setDefaultResponseTimeout(int responseTimeout) {
        if (this.verifyContextNotStarted()) {
            this.responseTimeout = responseTimeout;
        }
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public String getMuleHomeDirectory() {
        return System.getProperty("mule.home");
    }

    public void setWorkingDirectory(String workingDirectory) {
        if (this.verifyContextNotInitialized()) {
            try {
                File canonicalFile = FileUtils.openDirectory(workingDirectory);
                this.workingDirectory = canonicalFile.getCanonicalPath();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(CoreMessages.initialisationFailure("Invalid working directory").getMessage(), e);
            }
        }
    }

    @Override
    public int getDefaultTransactionTimeout() {
        return this.defaultTransactionTimeout;
    }

    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        if (this.verifyContextNotStarted()) {
            this.defaultTransactionTimeout = defaultTransactionTimeout;
        }
    }

    @Override
    public boolean isValidateExpressions() {
        return this.validateExpressions;
    }

    @Override
    public boolean isClientMode() {
        return this.clientMode;
    }

    @Override
    public String getDefaultEncoding() {
        return this.encoding;
    }

    public void setDefaultEncoding(String encoding) {
        if (this.verifyContextNotInitialized()) {
            this.encoding = encoding;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.verifyContextNotInitialized()) {
            if (StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("Cannot set server id to null/blank");
            }
            this.id = id;
        }
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        if (this.verifyContextNotInitialized()) {
            this.domainId = domainId;
        }
    }

    @Override
    public String getSystemModelType() {
        return this.systemModelType;
    }

    public void setSystemModelType(String systemModelType) {
        if (this.verifyContextNotStarted()) {
            this.systemModelType = systemModelType;
        }
    }

    public void setClientMode(boolean clientMode) {
        if (this.verifyContextNotStarted()) {
            this.clientMode = clientMode;
        }
    }

    @Override
    public String getSystemName() {
        return this.domainId + "." + this.clusterId + "." + this.id;
    }

    @Override
    public boolean isAutoWrapMessageAwareTransform() {
        return this.autoWrapMessageAwareTransform;
    }

    public void setAutoWrapMessageAwareTransform(boolean autoWrapMessageAwareTransform) {
        if (this.verifyContextNotStarted()) {
            this.autoWrapMessageAwareTransform = autoWrapMessageAwareTransform;
        }
    }

    @Override
    public boolean isCacheMessageAsBytes() {
        return this.cacheMessageAsBytes;
    }

    public void setCacheMessageAsBytes(boolean cacheMessageAsBytes) {
        if (this.verifyContextNotStarted()) {
            this.cacheMessageAsBytes = cacheMessageAsBytes;
        }
    }

    @Override
    public boolean isCacheMessageOriginalPayload() {
        return this.cacheMessageOriginalPayload;
    }

    public void setCacheMessageOriginalPayload(boolean cacheMessageOriginalPayload) {
        if (this.verifyContextNotStarted()) {
            this.cacheMessageOriginalPayload = cacheMessageOriginalPayload;
        }
    }

    @Override
    public boolean isEnableStreaming() {
        return this.enableStreaming;
    }

    public void setEnableStreaming(boolean enableStreaming) {
        if (this.verifyContextNotStarted()) {
            this.enableStreaming = enableStreaming;
        }
    }

    protected boolean verifyContextNotInitialized() {
        if (this.muleContext != null && this.muleContext.getLifecycleManager().isPhaseComplete("initialise")) {
            this.logger.warn((Object)"Cannot modify MuleConfiguration once the MuleContext has been initialized.  Modification will be ignored.");
            return false;
        }
        return true;
    }

    protected boolean verifyContextNotStarted() {
        if (this.muleContext != null && this.muleContext.getLifecycleManager().isPhaseComplete("start")) {
            this.logger.warn((Object)"Cannot modify MuleConfiguration once the MuleContext has been started.  Modification will be ignored.");
            return false;
        }
        return true;
    }

    @Override
    public int getDefaultQueueTimeout() {
        return this.defaultQueueTimeout;
    }

    public void setDefaultQueueTimeout(int defaultQueueTimeout) {
        if (this.verifyContextNotStarted()) {
            this.defaultQueueTimeout = defaultQueueTimeout;
        }
    }

    @Override
    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        if (this.verifyContextNotStarted()) {
            this.shutdownTimeout = shutdownTimeout;
        }
    }

    @Override
    public boolean isContainerMode() {
        return this.containerMode;
    }

    public void setContainerMode(boolean containerMode) {
        if (this.verifyContextNotInitialized()) {
            this.containerMode = containerMode;
        }
    }

    @Override
    public boolean isStandalone() {
        return this.getMuleHomeDirectory() != null;
    }

    public Map<String, String> getExtendedProperties() {
        return this.extendedProperties;
    }

    public void setExtendedProperties(Map<String, String> extendedProperties) {
        this.extendedProperties = extendedProperties;
    }

    public void setExtendedProperty(String name, String value) {
        this.extendedProperties.put(name, value);
    }

    public String getExtendedProperty(String name) {
        return this.extendedProperties.get(name);
    }

    @Override
    public String getDefaultExceptionStrategyName() {
        return this.defaultExceptionStrategyName;
    }

    public void setUseExtendedTransformations(boolean useExtendedTransformations) {
        if (this.verifyContextNotStarted()) {
            this.useExtendedTransformations = useExtendedTransformations;
        }
    }

    @Override
    public boolean useExtendedTransformations() {
        return this.useExtendedTransformations;
    }

    public void setFlowEndingWithOneWayEndpointReturnsNull(boolean flowEndingWithOneWayEndpointReturnsNull) {
        this.flowEndingWithOneWayEndpointReturnsNull = flowEndingWithOneWayEndpointReturnsNull;
    }

    @Override
    public boolean isFlowEndingWithOneWayEndpointReturnsNull() {
        return this.flowEndingWithOneWayEndpointReturnsNull;
    }

    public void setDefaultExceptionStrategyName(String defaultExceptionStrategyName) {
        this.defaultExceptionStrategyName = defaultExceptionStrategyName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.autoWrapMessageAwareTransform ? 1231 : 1237);
        result = 31 * result + (this.cacheMessageAsBytes ? 1231 : 1237);
        result = 31 * result + (this.cacheMessageOriginalPayload ? 1231 : 1237);
        result = 31 * result + (this.clientMode ? 1231 : 1237);
        result = 31 * result + this.defaultQueueTimeout;
        result = 31 * result + this.defaultTransactionTimeout;
        result = 31 * result + (this.domainId == null ? 0 : this.domainId.hashCode());
        result = 31 * result + (this.enableStreaming ? 1231 : 1237);
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + this.responseTimeout;
        result = 31 * result + this.shutdownTimeout;
        result = 31 * result + (this.useExtendedTransformations ? 1231 : 1237);
        result = 31 * result + (this.flowEndingWithOneWayEndpointReturnsNull ? 1231 : 1237);
        result = 31 * result + (this.synchronous ? 1231 : 1237);
        result = 31 * result + (this.systemModelType == null ? 0 : this.systemModelType.hashCode());
        result = 31 * result + (this.workingDirectory == null ? 0 : this.workingDirectory.hashCode());
        result = 31 * result + (this.containerMode ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultMuleConfiguration other = (DefaultMuleConfiguration)obj;
        if (this.autoWrapMessageAwareTransform != other.autoWrapMessageAwareTransform) {
            return false;
        }
        if (this.cacheMessageAsBytes != other.cacheMessageAsBytes) {
            return false;
        }
        if (this.cacheMessageOriginalPayload != other.cacheMessageOriginalPayload) {
            return false;
        }
        if (this.clientMode != other.clientMode) {
            return false;
        }
        if (this.defaultQueueTimeout != other.defaultQueueTimeout) {
            return false;
        }
        if (this.defaultTransactionTimeout != other.defaultTransactionTimeout) {
            return false;
        }
        if (this.domainId == null ? other.domainId != null : !this.domainId.equals(other.domainId)) {
            return false;
        }
        if (this.enableStreaming != other.enableStreaming) {
            return false;
        }
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.responseTimeout != other.responseTimeout) {
            return false;
        }
        if (this.shutdownTimeout != other.shutdownTimeout) {
            return false;
        }
        if (this.useExtendedTransformations != other.useExtendedTransformations) {
            return false;
        }
        if (this.flowEndingWithOneWayEndpointReturnsNull != other.flowEndingWithOneWayEndpointReturnsNull) {
            return false;
        }
        if (this.synchronous != other.synchronous) {
            return false;
        }
        if (this.systemModelType == null ? other.systemModelType != null : !this.systemModelType.equals(other.systemModelType)) {
            return false;
        }
        if (this.workingDirectory == null ? other.workingDirectory != null : !this.workingDirectory.equals(other.workingDirectory)) {
            return false;
        }
        return this.containerMode == other.containerMode;
    }
}

