/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.logging.Log;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.agent.Agent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.Model;
import org.mule.api.registry.InjectProcessor;
import org.mule.api.registry.ObjectProcessor;
import org.mule.api.registry.PreInitProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.MessageFactory;
import org.mule.registry.AbstractRegistry;
import org.mule.registry.ExpressionEnricherProcessor;
import org.mule.registry.ExpressionEvaluatorProcessor;
import org.mule.registry.LifecycleStateInjectorProcessor;
import org.mule.registry.MuleContextProcessor;
import org.mule.util.CollectionUtils;
import org.mule.util.StringUtils;

public class TransientRegistry
extends AbstractRegistry {
    public static final String REGISTRY_ID = "org.mule.Registry.Transient";
    private final RegistryMap registryMap;

    public TransientRegistry(MuleContext muleContext) {
        this(REGISTRY_ID, muleContext);
    }

    public TransientRegistry(String id, MuleContext muleContext) {
        super(id, muleContext);
        this.registryMap = new RegistryMap(this.logger);
        this.putDefaultEntriesIntoRegistry();
    }

    private void putDefaultEntriesIntoRegistry() {
        HashMap<String, Object> processors = new HashMap<String, Object>();
        processors.put("_muleContextProcessor", new MuleContextProcessor(this.muleContext));
        processors.put("_muleExpressionEvaluatorProcessor", new ExpressionEvaluatorProcessor(this.muleContext));
        processors.put("_muleExpressionEnricherProcessor", new ExpressionEnricherProcessor(this.muleContext));
        processors.put("_muleLifecycleStateInjectorProcessor", new LifecycleStateInjectorProcessor(this.getLifecycleManager().getState()));
        processors.put("_muleLifecycleManager", this.getLifecycleManager());
        this.registryMap.putAll(processors);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.applyProcessors(this.lookupObjects(Connector.class), null);
        this.applyProcessors(this.lookupObjects(Transformer.class), null);
        this.applyProcessors(this.lookupObjects(ImmutableEndpoint.class), null);
        this.applyProcessors(this.lookupObjects(Agent.class), null);
        this.applyProcessors(this.lookupObjects(Model.class), null);
        this.applyProcessors(this.lookupObjects(Service.class), null);
        this.applyProcessors(this.lookupObjects(Object.class), null);
    }

    @Override
    protected void doDispose() {
        this.registryMap.clear();
    }

    protected Map<String, Object> applyProcessors(Map<String, Object> objects) {
        if (objects == null) {
            return null;
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : objects.entrySet()) {
            Collection<ObjectProcessor> processors = this.lookupObjects(ObjectProcessor.class);
            for (ObjectProcessor processor : processors) {
                Object result = processor.process(entry.getValue());
                if (result == null) continue;
                results.put(entry.getKey(), result);
            }
        }
        return results;
    }

    @Override
    public void registerObjects(Map<String, Object> objects) throws RegistrationException {
        if (objects == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : objects.entrySet()) {
            this.registerObject(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            this.registryMap.lockForReading();
            for (Map.Entry<String, Object> entry : this.registryMap.entrySet()) {
                Class<?> clazz = entry.getValue().getClass();
                if (!type.isAssignableFrom(clazz)) continue;
                results.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.registryMap.unlockForReading();
        }
        return results;
    }

    @Override
    public <T> T lookupObject(String key) {
        return this.registryMap.get(key);
    }

    @Override
    public <T> Collection<T> lookupObjects(Class<T> returntype) {
        return this.registryMap.select((Predicate)new InstanceofPredicate(returntype));
    }

    Object applyLifecycle(Object object) throws MuleException {
        this.getLifecycleManager().applyCompletedPhases(object);
        return object;
    }

    Object applyLifecycle(Object object, String phase) throws MuleException {
        this.getLifecycleManager().applyPhase(object, "not in lifecycle", phase);
        return object;
    }

    Object applyProcessors(Object object, Object metadata) {
        Object theObject = object;
        if (!this.hasFlag(metadata, 2)) {
            Collection<InjectProcessor> injectProcessors = this.lookupObjects(InjectProcessor.class);
            for (InjectProcessor injectProcessor : injectProcessors) {
                theObject = injectProcessor.process(theObject);
            }
        }
        if (!this.hasFlag(metadata, 4)) {
            Collection<PreInitProcessor> processors = this.lookupObjects(PreInitProcessor.class);
            for (PreInitProcessor preInitProcessor : processors) {
                theObject = preInitProcessor.process(theObject);
                if (theObject != null) continue;
                return null;
            }
        }
        return theObject;
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        this.registerObject(key, value, Object.class);
    }

    @Override
    public void registerObject(String key, Object object, Object metadata) throws RegistrationException {
        this.checkDisposed();
        if (StringUtils.isBlank((String)key)) {
            throw new RegistrationException(MessageFactory.createStaticMessage("Attempt to register object with no key"));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("registering key/object %s/%s", key, object));
        }
        this.logger.debug((Object)"applying processors");
        object = this.applyProcessors(object, metadata);
        if (object == null) {
            return;
        }
        this.registryMap.putAndLogWarningIfDuplicate(key, object);
        try {
            if (!this.hasFlag(metadata, 1)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("applying lifecycle to object: " + object));
                }
                this.getLifecycleManager().applyCompletedPhases(object);
            }
        }
        catch (MuleException e) {
            throw new RegistrationException(e);
        }
    }

    protected void checkDisposed() throws RegistrationException {
        if (this.getLifecycleManager().isPhaseComplete("dispose")) {
            throw new RegistrationException(MessageFactory.createStaticMessage("Cannot register objects on the registry as the context is disposed"));
        }
    }

    protected boolean hasFlag(Object metaData, int flag) {
        return metaData != null && metaData instanceof Integer && ((Integer)metaData & flag) != 0;
    }

    @Override
    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        Object obj = this.registryMap.remove(key);
        try {
            if (!this.hasFlag(metadata, 1)) {
                this.getLifecycleManager().applyPhase(obj, this.lifecycleManager.getCurrentPhase(), "dispose");
            }
        }
        catch (MuleException e) {
            throw new RegistrationException(e);
        }
    }

    @Override
    public void unregisterObject(String key) throws RegistrationException {
        this.unregisterObject(key, Object.class);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    private static class RegistryMap {
        private final Map<String, Object> registry = new HashMap<String, Object>();
        private final ReadWriteLock registryLock = new ReentrantReadWriteLock();
        private Log logger;

        public RegistryMap(Log log) {
            this.logger = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<?> select(Predicate predicate) {
            Lock readLock = this.registryLock.readLock();
            try {
                readLock.lock();
                Collection collection = CollectionUtils.select(this.registry.values(), (Predicate)predicate);
                return collection;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Lock writeLock = this.registryLock.writeLock();
            try {
                writeLock.lock();
                this.registry.clear();
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAndLogWarningIfDuplicate(String key, Object object) {
            Lock writeLock = this.registryLock.writeLock();
            try {
                writeLock.lock();
                if (this.registry.containsKey(key)) {
                    this.logger.warn((Object)("TransientRegistry already contains an object named '" + key + "'.  The previous object will be overwritten."));
                }
                this.registry.put(key, object);
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putAll(Map<String, Object> map) {
            Lock writeLock = this.registryLock.writeLock();
            try {
                writeLock.lock();
                this.registry.putAll(map);
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T get(String key) {
            Lock readLock = this.registryLock.readLock();
            try {
                readLock.lock();
                Object object = this.registry.get(key);
                return (T)object;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(String key) {
            Lock writeLock = this.registryLock.writeLock();
            try {
                writeLock.lock();
                Object object = this.registry.remove(key);
                return object;
            }
            finally {
                writeLock.unlock();
            }
        }

        public Set<Map.Entry<String, Object>> entrySet() {
            return this.registry.entrySet();
        }

        public void lockForReading() {
            this.registryLock.readLock().lock();
        }

        public void unlockForReading() {
            this.registryLock.readLock().unlock();
        }
    }
}

